/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.experienceobelisk.utils;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;

public class ExperienceUtils {
    public static int levelsToXP(int levels) {
        if (levels <= 16) {
            return (int)(Math.pow(levels, 2.0) + (double)(6 * levels));
        }
        if (levels <= 31) {
            return (int)(2.5 * Math.pow(levels, 2.0) - 40.5 * (double)levels + 360.0);
        }
        return (int)(4.5 * Math.pow(levels, 2.0) - 162.5 * (double)levels + 2220.0);
    }

    public static int xpToLevels(long xp) {
        if (xp < 394L) {
            return (int)(Math.sqrt(xp + 9L) - 3.0);
        }
        if (xp < 1628L) {
            return (int)((Math.sqrt(40L * xp - 7839L) + 81.0) * 0.1);
        }
        return (int)((Math.sqrt(72L * xp - 54215L) + 325.0) / 18.0);
    }

    public static long getTotalXP(Player player) {
        return ExperienceUtils.levelsToXP(player.f_36078_) + Math.round(player.f_36080_ * (float)player.m_36323_());
    }

    public static long getTotalXP(int levels, float progress) {
        return ExperienceUtils.levelsToXP(levels) + Math.round(progress * (float)ExperienceUtils.getXpNeededForNextLevel(levels));
    }

    public static double getProgressToNextLevel(int experiencePoints, int experienceLevels) {
        int n = experiencePoints - ExperienceUtils.levelsToXP(experienceLevels);
        int m = ExperienceUtils.levelsToXP(experienceLevels + 1) - ExperienceUtils.levelsToXP(experienceLevels);
        return (double)n / (double)m;
    }

    public static long getXpNeededForNextLevel(int experienceLevel) {
        if (experienceLevel >= 30) {
            return 112L + (long)(experienceLevel - 30) * 9L;
        }
        return experienceLevel >= 15 ? (long)(37 + (experienceLevel - 15) * 5) : 7L + (long)experienceLevel * 2L;
    }

    public static int getOrbValue(ExperienceOrb orb) {
        CompoundTag tag = new CompoundTag();
        orb.m_7380_(tag);
        return orb.f_20770_ * tag.m_128451_("Count");
    }

    public static int getClumpedOrbValue(ExperienceOrb orb) {
        CompoundTag tag = new CompoundTag();
        orb.m_7380_(tag);
        int totalValue = 0;
        if (tag.m_128441_("clumpedMap")) {
            CompoundTag clumpedMap = tag.m_128469_("clumpedMap");
            for (String value : clumpedMap.m_128431_()) {
                totalValue += clumpedMap.m_128451_(value) * Integer.parseInt(value);
            }
        } else {
            totalValue = orb.f_20770_ * tag.m_128451_("Count");
        }
        return totalValue;
    }
}

