/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.experienceobelisk.recipe.jei;

import com.cyanogen.experienceobelisk.recipe.InfectingRecipe;
import com.cyanogen.experienceobelisk.registries.RegisterItems;
import com.cyanogen.experienceobelisk.utils.RecipeUtils;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class InfectingCategory
implements IRecipeCategory<InfectingRecipe> {
    IRecipeCategoryRegistration registration;
    IGuiHelper guiHelper;
    public final ResourceLocation infectingBackground = new ResourceLocation("experienceobelisk:textures/gui/recipes/infecting_jei.png");
    public final IDrawableAnimated arrow;
    public final IDrawable counterArrow;
    private final int arrowWidth = 41;
    private final int arrowHeight = 7;
    private final int arrowOffsetX = 49;
    private final int arrowOffsetY = 21;
    private final int counterArrowWidth = 11;
    private final int counterArrowHeight = 9;
    private final int counterArrowXOffset = 56;
    private final int counterArrowYOffset = 7;
    public static final RecipeType<InfectingRecipe> INFECTING_TYPE = RecipeType.create((String)"experienceobelisk", (String)"infecting", InfectingRecipe.class);

    public InfectingCategory(IRecipeCategoryRegistration registration) {
        this.registration = registration;
        this.guiHelper = registration.getJeiHelpers().getGuiHelper();
        this.arrow = this.guiHelper.drawableBuilder(this.infectingBackground, 0, 66, 41, 7).buildAnimated(100, IDrawableAnimated.StartDirection.LEFT, false);
        this.counterArrow = this.guiHelper.drawableBuilder(this.infectingBackground, 0, 73, 11, 9).build();
    }

    public RecipeType<InfectingRecipe> getRecipeType() {
        return INFECTING_TYPE;
    }

    public int getWidth() {
        return 136;
    }

    public int getHeight() {
        return 66;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"jei.experienceobelisk.infecting.title");
    }

    public IDrawable getBackground() {
        return this.guiHelper.createDrawable(this.infectingBackground, 0, 0, 136, 66);
    }

    public IDrawable getIcon() {
        ItemStack icon = new ItemStack((ItemLike)RegisterItems.BIBLIOPHAGE.get());
        return this.guiHelper.createDrawableItemStack(icon);
    }

    public void draw(InfectingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.guiHelper.createDrawable(this.infectingBackground, 0, 0, 136, 66).draw(guiGraphics);
        this.arrow.draw(guiGraphics, 49, 21);
        if (recipe.getInfectionCount() > 1) {
            this.counterArrow.draw(guiGraphics, 56, 7);
            guiGraphics.m_280056_(Minecraft.m_91087_().f_91062_, "x" + recipe.getInfectionCount(), 71, 8, 0x8B8B8B, false);
        }
    }

    public List<Component> getTooltipStrings(InfectingRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        this.getArrowTooltip(tooltip, mouseX, mouseY);
        this.getCounterArrowTooltip(recipe.getInfectionCount(), tooltip, mouseX, mouseY);
        return tooltip;
    }

    public void getArrowTooltip(List<Component> tooltipBuilder, double mouseX, double mouseY) {
        MutableComponent arrowTooltip = Component.m_237115_((String)"jei.experienceobelisk.infecting.tooltip");
        int x1 = 46;
        int x2 = 93;
        int y1 = 19;
        int y2 = 30;
        if (mouseX >= (double)x1 && mouseX <= (double)x2 && mouseY >= (double)y1 && mouseY <= (double)y2) {
            tooltipBuilder.add((Component)arrowTooltip);
        }
    }

    public void getCounterArrowTooltip(int infectionCount, List<Component> tooltipBuilder, double mouseX, double mouseY) {
        MutableComponent counterArrowTooltip = Component.m_237110_((String)"jei.experienceobelisk.infecting.tooltip_count", (Object[])new Object[]{Component.m_237113_((String)String.valueOf(infectionCount)).m_130940_(ChatFormatting.GREEN)});
        int x1 = 55;
        int x2 = 86;
        int y1 = 6;
        int y2 = 17;
        if (infectionCount > 1 && mouseX >= (double)x1 && mouseX <= (double)x2 && mouseY >= (double)y1 && mouseY <= (double)y2) {
            tooltipBuilder.add((Component)counterArrowTooltip);
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, InfectingRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 18, 18).setSlotName("input").addIngredients(recipe.getIngredient());
        builder.addSlot(RecipeIngredientRole.CATALYST, 61, 34).setSlotName("catalyst").addItemStacks(RecipeUtils.getCatalysts());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 102, 18).setSlotName("output").addItemStack(recipe.m_8043_(null));
    }
}

