/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.experienceobelisk.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class InfectingRecipe
implements Recipe<SimpleContainer> {
    private final Ingredient ingredientBlock;
    private final ItemStack resultBlock;
    private final int infectionCount;
    private final ResourceLocation id;

    public InfectingRecipe(Ingredient inputBlock, ItemStack resultBlock, int infectionCount, ResourceLocation id) {
        this.ingredientBlock = inputBlock;
        this.resultBlock = resultBlock;
        this.infectionCount = infectionCount;
        this.id = id;
    }

    @Nullable
    public static InfectingRecipe getRecipe(Level level, ItemStack stack) {
        List recipeList = level.m_7465_().m_44013_((RecipeType)Type.INSTANCE);
        InfectingRecipe infectingRecipe = null;
        for (InfectingRecipe recipe : recipeList) {
            if (!recipe.matches(stack)) continue;
            infectingRecipe = recipe;
            break;
        }
        return infectingRecipe;
    }

    @Nullable
    public static BlockState getInfectedBlockState(Level level, BlockState ingredientBlockState) {
        ItemStack result;
        Item item;
        ItemStack block = ingredientBlockState.m_60734_().m_5456_().m_7968_();
        InfectingRecipe recipe = InfectingRecipe.getRecipe(level, block);
        if (recipe != null && (item = (result = recipe.assemble(block)).m_41720_()) instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            return blockItem.m_40614_().m_49966_();
        }
        return null;
    }

    public boolean matches(ItemStack stack) {
        return this.matches(new SimpleContainer(new ItemStack[]{stack}), null);
    }

    public boolean matches(SimpleContainer container, @Nullable Level level) {
        return this.ingredientBlock.test(container.m_8020_(0));
    }

    public ItemStack assemble(ItemStack stack) {
        return this.assemble(new SimpleContainer(new ItemStack[]{stack}), null);
    }

    public ItemStack assemble(@Nullable SimpleContainer container, @Nullable RegistryAccess access) {
        return this.resultBlock.m_41777_();
    }

    public boolean m_8004_(int i, int i1) {
        return true;
    }

    public ItemStack m_8043_(@Nullable RegistryAccess access) {
        return this.resultBlock.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public Ingredient getIngredient() {
        return this.ingredientBlock;
    }

    public int getInfectionCount() {
        return this.infectionCount;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static class Type
    implements RecipeType<InfectingRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "infecting";
    }

    public static class Serializer
    implements RecipeSerializer<InfectingRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("experienceobelisk", "infecting");

        public InfectingRecipe fromJson(ResourceLocation id, JsonObject recipe) {
            Ingredient inputBlock = Ingredient.m_43917_((JsonElement)GsonHelper.m_289747_((JsonObject)recipe, (String)"ingredient"));
            ItemStack outputBlock = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)recipe, (String)"result"));
            int infectionCount = GsonHelper.m_13927_((JsonObject)recipe, (String)"infectionCount");
            return new InfectingRecipe(inputBlock, outputBlock, infectionCount, id);
        }

        @Nullable
        public InfectingRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            Ingredient inputBlock = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack outputBlock = buffer.m_130267_();
            int infectionCount = buffer.readInt();
            return new InfectingRecipe(inputBlock, outputBlock, infectionCount, id);
        }

        public void toNetwork(FriendlyByteBuf buffer, InfectingRecipe recipe) {
            recipe.getIngredient().m_43923_(buffer);
            buffer.writeItemStack(recipe.m_8043_(null), false);
            buffer.writeInt(recipe.infectionCount);
        }
    }
}

