/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.experienceobelisk.block_entities.bibliophage;

import com.cyanogen.experienceobelisk.item.BibliophageItem;
import com.cyanogen.experienceobelisk.recipe.InfectingRecipe;
import com.cyanogen.experienceobelisk.registries.RegisterTags;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AbstractInfectiveEntity
extends BlockEntity {
    public AbstractInfectiveEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void infectAdjacent(Level level, BlockPos pos) {
        HashMap<BlockPos, BlockState> adjacentMap = new HashMap<BlockPos, BlockState>();
        for (BlockPos adjacentPos : this.getAdjacents(pos)) {
            BlockState infectedState;
            BlockState adjacentState = level.m_8055_(adjacentPos);
            if (adjacentState.m_60795_() || adjacentState.m_204336_(RegisterTags.Blocks.INFECTIVE_BLOCKS) || (infectedState = InfectingRecipe.getInfectedBlockState(level, adjacentState)) == null) continue;
            adjacentMap.put(adjacentPos, infectedState);
        }
        if (!adjacentMap.isEmpty()) {
            int index = (int)Math.floor(Math.random() * (double)adjacentMap.size());
            BlockPos posToInfect = (BlockPos)adjacentMap.keySet().toArray()[index];
            BlockState newBlock = adjacentMap.getOrDefault(posToInfect, null);
            if (newBlock != null) {
                BibliophageItem.infectBlock(level, posToInfect, newBlock);
            }
        }
    }

    public List<BlockPos> getAdjacents(BlockPos pos) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        list.add(pos.m_7494_());
        list.add(pos.m_7495_());
        list.add(pos.m_122012_());
        list.add(pos.m_122019_());
        list.add(pos.m_122029_());
        list.add(pos.m_122024_());
        return list;
    }

    public List<BlockPos> getEdgeBlocks(BlockPos pos) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        BlockPos above = pos.m_7494_();
        BlockPos below = pos.m_7495_();
        list.add(above.m_122012_());
        list.add(above.m_122019_());
        list.add(above.m_122029_());
        list.add(above.m_122024_());
        list.add(below.m_122012_());
        list.add(below.m_122019_());
        list.add(below.m_122029_());
        list.add(below.m_122024_());
        list.add(pos.m_122012_().m_122024_());
        list.add(pos.m_122012_().m_122029_());
        list.add(pos.m_122019_().m_122024_());
        list.add(pos.m_122019_().m_122029_());
        return list;
    }

    public List<BlockPos> getVertexBlocks(BlockPos pos) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        BlockPos above = pos.m_7494_();
        BlockPos below = pos.m_7495_();
        list.add(above.m_122012_().m_122024_());
        list.add(above.m_122012_().m_122029_());
        list.add(above.m_122019_().m_122024_());
        list.add(above.m_122019_().m_122029_());
        list.add(below.m_122012_().m_122024_());
        list.add(below.m_122012_().m_122029_());
        list.add(below.m_122019_().m_122024_());
        list.add(below.m_122019_().m_122029_());
        return list;
    }
}

