/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.experienceobelisk.block_entities;

import com.cyanogen.experienceobelisk.block_entities.ExperienceObeliskEntity;
import com.cyanogen.experienceobelisk.utils.ExperienceUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class ExperienceReceivingEntity
extends BlockEntity {
    public int boundX;
    public int boundY;
    public int boundZ;
    public boolean isBound = false;
    public boolean obeliskStillExists = false;
    public int obeliskLevels = 0;
    public int obeliskPoints = 0;
    public double obeliskProgress = 0.0;
    public boolean redstoneEnabled = false;

    public ExperienceReceivingEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void setUnbound() {
        this.boundX = 0;
        this.boundY = 0;
        this.boundZ = 0;
        this.isBound = false;
        this.m_6596_();
    }

    public void setBoundPos(BlockPos pos) {
        this.boundX = pos.m_123341_();
        this.boundY = pos.m_123342_();
        this.boundZ = pos.m_123343_();
        this.isBound = true;
        this.m_6596_();
    }

    public BlockPos getBoundPos() {
        return new BlockPos(this.boundX, this.boundY, this.boundZ);
    }

    public ExperienceObeliskEntity getBoundObelisk() {
        BlockEntity blockEntity;
        if (this.isBound && this.f_58857_ != null && (blockEntity = this.f_58857_.m_7702_(this.getBoundPos())) instanceof ExperienceObeliskEntity) {
            ExperienceObeliskEntity obelisk = (ExperienceObeliskEntity)blockEntity;
            return obelisk;
        }
        return null;
    }

    public void sendObeliskInfoToScreen() {
        boolean exists;
        ExperienceObeliskEntity obelisk = this.getBoundObelisk();
        this.obeliskStillExists = exists = obelisk != null;
        this.obeliskLevels = exists ? obelisk.getLevels() : 0;
        this.obeliskPoints = exists ? obelisk.getExperiencePoints() : 0;
        this.obeliskProgress = ExperienceUtils.getProgressToNextLevel(this.obeliskPoints, this.obeliskLevels);
    }

    public boolean isRedstoneEnabled() {
        return this.redstoneEnabled;
    }

    public void setRedstoneEnabled(boolean enabled) {
        this.redstoneEnabled = enabled;
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
        }
        this.m_6596_();
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.isBound = tag.m_128471_("isBound");
        this.boundX = tag.m_128451_("BoundX");
        this.boundY = tag.m_128451_("BoundY");
        this.boundZ = tag.m_128451_("BoundZ");
        this.redstoneEnabled = tag.m_128471_("RedstoneEnabled");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("isBound", this.isBound);
        tag.m_128405_("BoundX", this.boundX);
        tag.m_128405_("BoundY", this.boundY);
        tag.m_128405_("BoundZ", this.boundZ);
        tag.m_128379_("RedstoneEnabled", this.redstoneEnabled);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128379_("isBound", this.isBound);
        tag.m_128405_("BoundX", this.boundX);
        tag.m_128405_("BoundY", this.boundY);
        tag.m_128405_("BoundZ", this.boundZ);
        tag.m_128379_("RedstoneEnabled", this.redstoneEnabled);
        return tag;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }
}

