/*
 * Decompiled with CFR 0.152.
 */
package com.rosemods.heart_crystals.core.other;

import com.rosemods.heart_crystals.core.HCConfig;
import com.rosemods.heart_crystals.core.HeartCrystals;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.PacketDistributor;

public class HCPlayerInfo {
    public static final Capability<PlayerHealthInfo> HEALTH_INFO_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerHealthInfo>(){});

    public static PlayerHealthInfo getPlayerHealthInfo(Entity entity) {
        return (PlayerHealthInfo)entity.getCapability(HEALTH_INFO_CAPABILITY, null).orElse((Object)new PlayerHealthInfo());
    }

    public static class PlayerHealthInfo {
        public int heartCount;
        public boolean healthSet;

        public PlayerHealthInfo() {
            this.heartCount = (Integer)HCConfig.COMMON.minimum.get();
            this.healthSet = false;
        }

        public void syncHealthInfo(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                HeartCrystals.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerHealthInfoSync(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128405_("PlayerHeartsCount", this.heartCount);
            nbt.m_128379_("PlayerBaseHealthSet", this.healthSet);
            return nbt;
        }

        public void readNBT(Tag Tag2) {
            CompoundTag nbt = (CompoundTag)Tag2;
            this.heartCount = nbt.m_128451_("PlayerHeartsCount");
            this.healthSet = nbt.m_128471_("PlayerBaseHealthSet");
        }
    }

    public static class PlayerHealthInfoProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerHealthInfo info = new PlayerHealthInfo();
        private final LazyOptional<PlayerHealthInfo> instance = LazyOptional.of(() -> this.info);

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == HEALTH_INFO_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.info.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.info.readNBT(nbt);
        }
    }

    public static class PlayerHealthInfoSync {
        private final PlayerHealthInfo info;

        public PlayerHealthInfoSync(PlayerHealthInfo info) {
            this.info = info;
        }

        public PlayerHealthInfoSync(FriendlyByteBuf buffer) {
            this.info = new PlayerHealthInfo();
            this.info.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerHealthInfo getHealthInfo() {
            return this.info;
        }

        public static void buffer(PlayerHealthInfoSync message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.getHealthInfo().writeNBT());
        }
    }
}

