/*
 * Decompiled with CFR 0.152.
 */
package com.rosemods.heart_crystals.core.other;

import com.rosemods.heart_crystals.core.HCConfig;
import com.rosemods.heart_crystals.core.HeartCrystals;
import com.rosemods.heart_crystals.core.other.HCPlayerInfo;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="heart_crystals")
public class HCEvents {
    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        HCEvents.syncPlayerInfo(player);
        if (player != null) {
            HCPlayerInfo.PlayerHealthInfo info = HCPlayerInfo.getPlayerHealthInfo((Entity)player);
            int minimum = (Integer)HCConfig.COMMON.minimum.get();
            if (!info.healthSet) {
                HCEvents.setMaxHealthAttribute(minimum * 2, player);
                player.m_21153_((float)(minimum * 2));
                info.healthSet = true;
                info.syncHealthInfo((Entity)player);
            } else if (info.heartCount < (Integer)HCConfig.COMMON.minimum.get()) {
                HCEvents.setMaxHealthAttribute(minimum * 2, player);
                player.m_21153_((float)(minimum * 2));
                info.heartCount = minimum;
                info.syncHealthInfo((Entity)player);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        HCEvents.syncPlayerInfo(event.getEntity());
        if (player != null) {
            HCPlayerInfo.PlayerHealthInfo info = HCPlayerInfo.getPlayerHealthInfo((Entity)player);
            HCEvents.setMaxHealthAttribute(info.heartCount * 2, player);
            player.m_21153_((float)(info.heartCount * 2));
        }
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        HCEvents.syncPlayerInfo(event.getEntity());
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        event.getOriginal().revive();
        HCPlayerInfo.PlayerHealthInfo original = HCPlayerInfo.getPlayerHealthInfo((Entity)event.getOriginal());
        HCPlayerInfo.PlayerHealthInfo clone = HCPlayerInfo.getPlayerHealthInfo((Entity)event.getEntity());
        clone.heartCount = original.heartCount;
        clone.healthSet = original.healthSet;
    }

    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
            event.addCapability(HeartCrystals.location("player_info"), (ICapabilityProvider)new HCPlayerInfo.PlayerHealthInfoProvider());
        }
    }

    public static void setMaxHealthAttribute(int health, Player player) {
        AttributeInstance attribute;
        if (!player.m_9236_().m_5776_() && player.m_20194_() != null && (attribute = player.m_21204_().m_22146_(Attributes.f_22276_)) != null) {
            attribute.m_22100_((double)health);
        }
    }

    private static void syncPlayerInfo(Player player) {
        if (player != null && !player.m_9236_().m_5776_()) {
            HCPlayerInfo.getPlayerHealthInfo((Entity)player).syncHealthInfo((Entity)player);
        }
    }
}

