/*
 * Decompiled with CFR 0.152.
 */
package com.rosemods.heart_crystals.core.other;

import com.rosemods.heart_crystals.core.HeartCrystals;
import com.rosemods.heart_crystals.core.registry.HCFeatures;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.registries.ForgeRegistries;

public final class HCBiomeModifiers {
    public static void bootstrap(BootstapContext<BiomeModifier> context) {
        HCBiomeModifiers.addFeature(context, "heart_crystal", (TagKey<Biome>)BiomeTags.f_215817_, GenerationStep.Decoration.UNDERGROUND_ORES, HCFeatures.Placements.HEART_CRYSTAL);
    }

    @SafeVarargs
    private static void addFeature(BootstapContext<BiomeModifier> context, String name, TagKey<Biome> biomes, GenerationStep.Decoration step, ResourceKey<PlacedFeature> ... features) {
        HCBiomeModifiers.register(context, "add_feature/" + name, () -> new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)context.m_255420_(Registries.f_256952_).m_254956_(biomes), HCBiomeModifiers.featureSet(context, features), step));
    }

    private static void register(BootstapContext<BiomeModifier> context, String name, Supplier<? extends BiomeModifier> modifier) {
        context.m_255272_(ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)HeartCrystals.location(name)), (Object)modifier.get());
    }

    @SafeVarargs
    private static HolderSet<PlacedFeature> featureSet(BootstapContext<?> context, ResourceKey<PlacedFeature> ... features) {
        return HolderSet.m_205800_(Stream.of(features).map(placedFeatureKey -> context.m_255420_(Registries.f_256988_).m_255043_(placedFeatureKey)).collect(Collectors.toList()));
    }
}

