/*
 * Decompiled with CFR 0.152.
 */
package com.rosemods.heart_crystals.core.data.client;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;

public abstract class ParticleProvider
implements DataProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final PackOutput packOutput;
    private final String modid;
    private final Map<String, ParticleDefinition> particles = new LinkedHashMap<String, ParticleDefinition>();

    public ParticleProvider(PackOutput packOutput, String modid) {
        this.packOutput = packOutput;
        this.modid = modid;
    }

    protected abstract void addParticles();

    protected void add(ParticleType<?> particle, String ... textures) {
        this.particles.put(ForgeRegistries.PARTICLE_TYPES.getKey(particle).m_135815_(), new ParticleDefinition(Arrays.stream(textures).map(s -> new ResourceLocation(this.modid, s).toString()).toList()));
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        this.addParticles();
        CompletableFuture[] futures = new CompletableFuture[this.particles.size()];
        int i = 0;
        for (Map.Entry<String, ParticleDefinition> entry : this.particles.entrySet()) {
            Path path = this.packOutput.m_245114_().resolve("assets/" + this.modid + "/particles/" + entry.getKey() + ".json");
            futures[i] = DataProvider.m_253162_((CachedOutput)cache, (JsonElement)entry.getValue().serialize(), (Path)path);
            ++i;
        }
        return CompletableFuture.allOf(futures);
    }

    public String m_6055_() {
        return "Particles: " + this.modid;
    }

    private record ParticleDefinition(List<String> entries) {
        private static final Codec<ParticleDefinition> CODEC = RecordCodecBuilder.create(textures -> textures.group((App)Codec.STRING.listOf().fieldOf("textures").forGetter(ParticleDefinition::entries)).apply((Applicative)textures, ParticleDefinition::new));

        public JsonElement serialize() {
            return (JsonElement)CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0));
        }
    }
}

