/*
 * Decompiled with CFR 0.152.
 */
package com.rosemods.heart_crystals.core.data.client;

import com.google.common.collect.Lists;
import com.rosemods.heart_crystals.core.HeartCrystals;
import com.rosemods.heart_crystals.core.other.HCTrimMaterials;
import com.rosemods.heart_crystals.core.registry.HCBlocks;
import com.rosemods.heart_crystals.core.registry.HCEntityTypes;
import com.rosemods.heart_crystals.core.registry.HCItems;
import com.rosemods.heart_crystals.core.registry.HCPaintingVariants;
import java.util.List;
import java.util.function.Function;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.codehaus.plexus.util.StringUtils;

public class HCLanguageProvider
extends LanguageProvider {
    private final List<String> keys = Lists.newArrayList();

    public HCLanguageProvider(GatherDataEvent event) {
        super(event.getGenerator().getPackOutput(), "heart_crystals", "en_us");
    }

    protected void addTranslations() {
        this.translateBannerPattern(HCItems.HEART_BANNER_PATTERN, "heart");
        this.add((Item)HCItems.CUPIDS_ARROW.get(), "Cupid's Arrow");
        this.addDescription(HCBlocks.HEART_CRYSTAL, "+1 Permanent Heart (Max %s)");
        this.add(((Block)HCBlocks.HEART_CRYSTAL.get()).m_7705_() + ".maximum", "Cannot use heart crystal; currently at maximum hearts!");
        this.add((EntityType)HCEntityTypes.CUPIDS_ARROW.get(), "Cupid's Arrow");
        this.translatePainting(HCPaintingVariants.HEARTBEAT, "Yapettoshen");
        this.translateTrimMaterial(HCTrimMaterials.HEART_CRYSTAL_SHARD, "Heart Crystal Material");
        this.translateRegistry(ForgeRegistries.BLOCKS, Block::m_7705_);
    }

    private <T> void translateRegistry(IForgeRegistry<T> registry, Function<T, String> toString) {
        for (RegistryObject object : HeartCrystals.REGISTRY_HELPER.getSubHelper(registry).getDeferredRegister().getEntries()) {
            this.add(toString.apply(object.get()), HCLanguageProvider.toUpper(registry, object));
        }
    }

    private void translateTrimMaterial(ResourceKey<TrimMaterial> material, String name) {
        this.add("trim_material." + material.m_135782_().toString().replace(':', '.'), name);
    }

    public void add(String key, String value) {
        if (!this.keys.contains(key)) {
            super.add(key, value);
            this.keys.add(key);
        }
    }

    private void translatePainting(RegistryObject<PaintingVariant> painting, String author) {
        String name = ForgeRegistries.PAINTING_VARIANTS.getKey((Object)((PaintingVariant)painting.get())).m_135815_();
        this.add("painting.heart_crystals." + name + ".title", HCLanguageProvider.toUpper(name));
        this.add("painting.heart_crystals." + name + ".author", author);
    }

    private void translateBannerPattern(RegistryObject<? extends Item> item, String name) {
        String desc = HCLanguageProvider.toUpper(name);
        this.add((Item)item.get(), "Banner Pattern");
        this.addDescription(item, desc);
        for (DyeColor dye : DyeColor.values()) {
            this.add("block.minecraft.banner.heart_crystals." + name + "." + dye.m_41065_(), HCLanguageProvider.toUpper(dye.m_41065_()) + " " + desc);
        }
    }

    private void addDescription(RegistryObject<? extends ItemLike> item, String desc) {
        this.add(((ItemLike)item.get()).m_5456_().m_5524_() + ".desc", desc);
    }

    private static <T> String toUpper(IForgeRegistry<T> registry, RegistryObject<? extends T> object) {
        return HCLanguageProvider.toUpper(registry.getKey(object.get()).m_135815_());
    }

    private static String toUpper(String string) {
        return StringUtils.capitaliseAllWords((String)string.replace('_', ' '));
    }
}

