/*
 * Decompiled with CFR 0.152.
 */
package com.rosemods.heart_crystals.core;

import com.rosemods.heart_crystals.common.dispense.CupidsArrowDispenseBehavior;
import com.rosemods.heart_crystals.core.HCConfig;
import com.rosemods.heart_crystals.core.data.client.HCLanguageProvider;
import com.rosemods.heart_crystals.core.data.client.HCModelProvider;
import com.rosemods.heart_crystals.core.data.client.HCParticleProvider;
import com.rosemods.heart_crystals.core.data.client.HCSoundProvider;
import com.rosemods.heart_crystals.core.data.client.HCSpriteSourceProvider;
import com.rosemods.heart_crystals.core.data.server.HCDatapackBuiltinEntriesProvider;
import com.rosemods.heart_crystals.core.data.server.HCLootTableProvider;
import com.rosemods.heart_crystals.core.data.server.HCRecipeProvider;
import com.rosemods.heart_crystals.core.data.server.tags.HCBannerPatternTagProvider;
import com.rosemods.heart_crystals.core.data.server.tags.HCBlockTagProvider;
import com.rosemods.heart_crystals.core.data.server.tags.HCItemTagProvider;
import com.rosemods.heart_crystals.core.data.server.tags.HCPaintingVariantTagsProvider;
import com.rosemods.heart_crystals.core.data.server.tags.HCTrimMaterialTagsProvider;
import com.rosemods.heart_crystals.core.other.HCClientSync;
import com.rosemods.heart_crystals.core.other.HCPlayerInfo;
import com.rosemods.heart_crystals.core.registry.HCBannerPatterns;
import com.rosemods.heart_crystals.core.registry.HCBlocks;
import com.rosemods.heart_crystals.core.registry.HCEntityTypes;
import com.rosemods.heart_crystals.core.registry.HCFeatures;
import com.rosemods.heart_crystals.core.registry.HCItems;
import com.rosemods.heart_crystals.core.registry.HCPaintingVariants;
import com.rosemods.heart_crystals.core.registry.HCParticleTypes;
import com.teamabnormals.blueprint.core.util.DataUtil;
import com.teamabnormals.blueprint.core.util.registry.RegistryHelper;
import com.teamabnormals.gallery.core.data.client.GalleryAssetsRemolderProvider;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

@Mod(value="heart_crystals")
public class HeartCrystals {
    public static final String MOD_ID = "heart_crystals";
    public static final RegistryHelper REGISTRY_HELPER = new RegistryHelper("heart_crystals");
    public static final SimpleChannel PACKET_HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)REGISTRY_HELPER.prefix("heart_crystals"), () -> "1", "1"::equals, "1"::equals);

    public HeartCrystals() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext context = ModLoadingContext.get();
        REGISTRY_HELPER.register(bus);
        HCBannerPatterns.BANNER_PATTERNS.register(bus);
        HCPaintingVariants.PAINTING_VARIANTS.register(bus);
        HCFeatures.FEATURES.register(bus);
        HCParticleTypes.PARTICLE_TYPES.register(bus);
        bus.addListener(this::commonSetup);
        bus.addListener(this::clientSetup);
        bus.addListener(this::registerCapabilities);
        bus.addListener(this::dataSetup);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            HCBlocks.setupTabEditors();
            HCItems.setupTabEditors();
        });
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)HCConfig.COMMON_SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        HeartCrystals.registerMessage();
        event.enqueueWork(() -> {
            DataUtil.addMix((Potion)Potions.f_43602_, (Item)((Block)HCBlocks.HEART_CRYSTAL_SHARD.get()).m_5456_(), (Potion)Potions.f_43587_);
            DispenserBlock.m_52672_((ItemLike)((ItemLike)HCItems.CUPIDS_ARROW.get()), (DispenseItemBehavior)new CupidsArrowDispenseBehavior());
        });
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(HCEntityTypes::registerClient);
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.register(HCPlayerInfo.PlayerHealthInfo.class);
    }

    private void dataSetup(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        boolean client = event.includeClient();
        boolean server = event.includeServer();
        gen.addProvider(client, (DataProvider)new HCLanguageProvider(event));
        gen.addProvider(client, (DataProvider)new HCModelProvider(event));
        gen.addProvider(client, (DataProvider)new HCSoundProvider(event));
        gen.addProvider(client, (DataProvider)new HCSpriteSourceProvider(event));
        gen.addProvider(client, (DataProvider)new HCParticleProvider(event));
        gen.addProvider(client, (DataProvider)new GalleryAssetsRemolderProvider(MOD_ID, event.getGenerator().getPackOutput(), event.getLookupProvider()));
        gen.addProvider(server, (DataProvider)new HCLootTableProvider(event));
        gen.addProvider(server, (DataProvider)new HCRecipeProvider(event));
        HCDatapackBuiltinEntriesProvider dataPack = new HCDatapackBuiltinEntriesProvider(event);
        gen.addProvider(server, (DataProvider)dataPack);
        HCBlockTagProvider blockTags = new HCBlockTagProvider(event);
        gen.addProvider(server, (DataProvider)blockTags);
        gen.addProvider(server, (DataProvider)new HCItemTagProvider(event, blockTags, dataPack));
        gen.addProvider(server, (DataProvider)new HCBannerPatternTagProvider(event, dataPack));
        gen.addProvider(server, (DataProvider)new HCPaintingVariantTagsProvider(event, dataPack));
        gen.addProvider(server, (DataProvider)new HCTrimMaterialTagsProvider(event, dataPack));
    }

    private static void registerMessage() {
        PACKET_HANDLER.registerMessage(0, HCPlayerInfo.PlayerHealthInfoSync.class, HCPlayerInfo.PlayerHealthInfoSync::buffer, HCPlayerInfo.PlayerHealthInfoSync::new, (msg, ctx) -> HCClientSync.receivePacket(msg, ctx));
    }

    public static ResourceLocation location(String path) {
        return new ResourceLocation(MOD_ID, path);
    }
}

