/*
 * Decompiled with CFR 0.152.
 */
package xyz.kohara.adjcore.mixins.items;

import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.SpectralArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xyz.kohara.adjcore.misc.CrossbowEnchantmentApplier;

@Mixin(value={CrossbowItem.class})
public abstract class CrossbowMixin {
    @Shadow
    private static void m_40928_(ItemStack crossbowStack, ItemStack ammoStack) {
    }

    @Inject(method={"getChargeDuration"}, at={@At(value="HEAD")}, cancellable=true)
    private static void modifyPullTime(ItemStack crossbowStack, CallbackInfoReturnable<Integer> cir) {
        int lvl = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)crossbowStack);
        int reduction = 0;
        for (int i = 0; i < lvl; ++i) {
            reduction += 5 - i;
        }
        int pullTime = 30 - reduction;
        cir.setReturnValue((Object)pullTime);
    }

    @Inject(method={"getArrow"}, at={@At(value="TAIL")})
    private static void applyEnchantsToArrow(Level level, LivingEntity livingEntity, ItemStack crossbowStack, ItemStack ammoStack, CallbackInfoReturnable<AbstractArrow> cir) {
        AbstractArrow persistentProjectileEntity = (AbstractArrow)cir.getReturnValue();
        if (!(persistentProjectileEntity instanceof Arrow) && !(persistentProjectileEntity instanceof SpectralArrow)) {
            return;
        }
        CrossbowEnchantmentApplier.applyFlame(persistentProjectileEntity, crossbowStack);
        CrossbowEnchantmentApplier.applyInfinity(persistentProjectileEntity, crossbowStack, ammoStack);
        CrossbowEnchantmentApplier.applyPower(persistentProjectileEntity, crossbowStack);
        CrossbowEnchantmentApplier.applyPunch(persistentProjectileEntity, crossbowStack);
    }

    @Inject(method={"loadProjectile"}, at={@At(value="HEAD")}, cancellable=true)
    private static void loadProjectile(LivingEntity shooter, ItemStack crossbowStack, ItemStack ammoStack, boolean hasAmmo, boolean isCreative, CallbackInfoReturnable<Boolean> cir) {
        if (ammoStack.m_41619_()) {
            cir.setReturnValue((Object)false);
        } else {
            ItemStack itemstack;
            boolean saveArrow;
            boolean flag = isCreative && ammoStack.m_41720_() instanceof ArrowItem;
            boolean bl = saveArrow = isCreative || EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)crossbowStack) > 0;
            if (!(flag || saveArrow || hasAmmo)) {
                itemstack = ammoStack.m_41620_(1);
                if (ammoStack.m_41619_() && shooter instanceof Player) {
                    ((Player)shooter).m_150109_().m_36057_(ammoStack);
                }
            } else {
                itemstack = ammoStack.m_41777_();
            }
            CrossbowMixin.m_40928_(crossbowStack, itemstack);
            cir.setReturnValue((Object)true);
        }
    }
}

