/*
 * Decompiled with CFR 0.152.
 */
package xyz.kohara.adjcore.mixins.entity;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.List;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xyz.kohara.adjcore.Config;
import xyz.kohara.adjcore.misc.ArsManaShenanigans;

@Mixin(value={Player.class})
public abstract class PlayerMixin
extends LivingEntity
implements ArsManaShenanigans {
    @Unique
    public int adjcore$manaRegenDelay;
    @Unique
    public int adjcore$manaRegenTimer;

    protected PlayerMixin(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    @ModifyExpressionValue(method={"attack"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;onClimbable()Z")})
    private boolean adjUtils$canCrit(boolean isOnClimbable) {
        return (Boolean)Config.DISABLE_CRITS.get() != false || isOnClimbable;
    }

    @ModifyExpressionValue(method={"attack"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;getEntitiesOfClass(Ljava/lang/Class;Lnet/minecraft/world/phys/AABB;)Ljava/util/List;")})
    private List<LivingEntity> adjUtils$modifyListOfSweepAttacks(List<LivingEntity> listOfSweepAttacks) {
        return (Boolean)Config.DISABLE_SWEEP_ATTACKS.get() != false ? List.of() : listOfSweepAttacks;
    }

    @Redirect(method={"drop(Lnet/minecraft/world/item/ItemStack;ZZ)Lnet/minecraft/world/entity/item/ItemEntity;"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/item/ItemEntity;setDeltaMovement(DDD)V", ordinal=0))
    private void changeDropVelocity(ItemEntity instance, double x, double y, double z, @Local ItemEntity itementity) {
        float f = this.f_19796_.m_188501_() * 0.15f;
        float f1 = this.f_19796_.m_188501_() * ((float)Math.PI * 2);
        itementity.m_20334_((double)(-Mth.m_14031_((float)f1) * f), (double)0.2f, (double)(Mth.m_14089_((float)f1) * f));
    }

    @ModifyReturnValue(method={"drop(Lnet/minecraft/world/item/ItemStack;ZZ)Lnet/minecraft/world/entity/item/ItemEntity;"}, at={@At(value="RETURN")})
    private ItemEntity makeDespawnLonger(ItemEntity original) {
        if (original == null) {
            return null;
        }
        original.lifespan *= 3;
        return original;
    }

    @Override
    public int adjcore$getManaRegenDelay() {
        return this.adjcore$manaRegenDelay;
    }

    @Override
    public void adjcore$setManaRegenDelay(int cooldown) {
        this.adjcore$manaRegenDelay = cooldown;
    }

    @Override
    public void adjcore$increaseManaRegenCounter(int amount) {
        this.adjcore$manaRegenTimer += amount;
    }

    @Override
    public int adjcore$getManaRegenCounter() {
        return this.adjcore$manaRegenTimer;
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void onTick(CallbackInfo ci) {
        Player player = (Player)this;
        if (player.m_9236_().m_5776_()) {
            return;
        }
        if (this.adjcore$manaRegenDelay > 0) {
            --this.adjcore$manaRegenDelay;
        }
    }
}

