/*
 * Decompiled with CFR 0.152.
 */
package xyz.kohara.adjcore.mixins.enchantments;

import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.ThornsEnchantment;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ThornsEnchantment.class})
public class ThornsMixin {
    @Inject(method={"canEnchant"}, cancellable=true, at={@At(value="HEAD")})
    public void isAcceptableItem(ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)EnchantmentCategory.ARMOR_CHEST.m_7454_(stack.m_41720_()));
    }

    @Inject(method={"shouldHit"}, cancellable=true, at={@At(value="HEAD")})
    private static void shouldDamageAttacker(int level, RandomSource random, CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)(random.m_188501_() < 0.2f + (float)level * 0.1f ? 1 : 0));
    }

    @Inject(method={"getDamage"}, cancellable=true, at={@At(value="HEAD")})
    private static void getDamageAmount(int level, RandomSource random, CallbackInfoReturnable<Integer> cir) {
        if (level == 1) {
            cir.setReturnValue((Object)(1 + random.m_188503_(2)));
        } else if (level == 2) {
            cir.setReturnValue((Object)(1 + random.m_188503_(3)));
        } else if (level == 3) {
            cir.setReturnValue((Object)(2 + random.m_188503_(2)));
        } else {
            cir.setReturnValue((Object)(1 + random.m_188503_(4)));
        }
    }
}

