/*
 * Decompiled with CFR 0.152.
 */
package xyz.kohara.adjcore.mixins.enchantments;

import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.enchantment.DamageEnchantment;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={DamageEnchantment.class})
public class SharpnessMixin
extends Enchantment {
    protected SharpnessMixin(Enchantment.Rarity rarity, EnchantmentCategory category, EquipmentSlot[] applicableSlots) {
        super(rarity, category, applicableSlots);
    }

    @Inject(method={"getMaxLevel"}, at={@At(value="HEAD")}, cancellable=true)
    public void getMaxLevel(CallbackInfoReturnable<Integer> cir) {
        cir.setReturnValue((Object)4);
    }

    @Inject(method={"canEnchant"}, cancellable=true, at={@At(value="HEAD")})
    public void isAcceptableItem(ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        boolean canEnchant = stack.m_41720_() instanceof AxeItem;
        if (stack.m_41720_() instanceof TridentItem) {
            canEnchant = true;
        }
        if (super.m_6081_(stack)) {
            canEnchant = true;
        }
        cir.setReturnValue((Object)canEnchant);
    }

    @Inject(method={"checkCompatibility"}, at={@At(value="HEAD")}, cancellable=true)
    private void compatibleWithEverything(Enchantment other, CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)true);
    }

    @Inject(method={"getDamageBonus"}, at={@At(value="HEAD")}, cancellable=true)
    public void getDamageBonus(int level, MobType type, CallbackInfoReturnable<Float> cir) {
        cir.cancel();
        DamageEnchantment enchantment = (DamageEnchantment)this;
        if (enchantment.f_44621_ == 0) {
            float amount = 2.5f + 1.5f * (float)(level - 1);
            cir.setReturnValue((Object)Float.valueOf(amount));
        } else if (enchantment.f_44621_ == 1 && type == MobType.f_21641_) {
            float amount = 3.0f + 2.0f * (float)(level - 1);
            cir.setReturnValue((Object)Float.valueOf(amount));
        } else {
            float amount = 3.0f + 2.0f * (float)(level - 1);
            cir.setReturnValue((Object)Float.valueOf(enchantment.f_44621_ == 2 && type == MobType.f_21642_ ? amount : 0.0f));
        }
    }
}

