/*
 * Decompiled with CFR 0.152.
 */
package xyz.kohara.adjcore.mixins.enchantments;

import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xyz.kohara.adjcore.combat.ModDamageTypeTags;

@Mixin(value={ProtectionEnchantment.class})
public class ProtectionMixin {
    @Inject(method={"getMaxLevel"}, at={@At(value="HEAD")}, cancellable=true)
    public void getMaxLevel(CallbackInfoReturnable<Integer> cir) {
        cir.setReturnValue((Object)4);
    }

    @Inject(method={"checkCompatibility"}, at={@At(value="HEAD")}, cancellable=true)
    private void compatibleWithEverything(Enchantment other, CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)true);
    }

    @Inject(method={"getFireAfterDampener"}, at={@At(value="HEAD")}, cancellable=true)
    private static void getFireAfterDampener(LivingEntity livingEntity, int level, CallbackInfoReturnable<Integer> cir) {
        int i = EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44968_, (LivingEntity)livingEntity);
        if (i > 0) {
            level -= Mth.m_14143_((float)((float)level * ((float)i * 0.15f)));
        }
        cir.setReturnValue((Object)level);
    }

    @Inject(method={"getExplosionKnockbackAfterDampener"}, at={@At(value="HEAD")}, cancellable=true)
    private static void getExplosionKnockbackAfterDampener(LivingEntity livingEntity, double damage, CallbackInfoReturnable<Double> cir) {
        int i = EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44968_, (LivingEntity)livingEntity);
        if (i > 0) {
            damage *= Mth.m_14008_((double)(1.0 - (double)i * 0.15), (double)0.0, (double)1.0);
        }
        cir.setReturnValue((Object)damage);
    }

    @Inject(method={"getDamageProtection"}, at={@At(value="HEAD")}, cancellable=true)
    public void getDamageProtection(int level, DamageSource source, CallbackInfoReturnable<Integer> cir) {
        ProtectionEnchantment enchantment = (ProtectionEnchantment)this;
        if (source.m_269533_(DamageTypeTags.f_268738_)) {
            cir.setReturnValue((Object)0);
        } else if (enchantment.f_45124_ == ProtectionEnchantment.Type.ALL && source.m_269533_(ModDamageTypeTags.IS_PHYSICAL)) {
            cir.setReturnValue((Object)level);
        } else if (enchantment.f_45124_ == ProtectionEnchantment.Type.EXPLOSION && source.m_269533_(ModDamageTypeTags.IS_ENVIRONMENTAL)) {
            cir.setReturnValue((Object)(level * 2));
        } else if (enchantment.f_45124_ == ProtectionEnchantment.Type.FALL && source.m_269533_(DamageTypeTags.f_268549_)) {
            cir.setReturnValue((Object)(level * 4));
        } else {
            cir.setReturnValue((Object)0);
        }
    }
}

