/*
 * Decompiled with CFR 0.152.
 */
package xyz.kohara.adjcore.mixins.client;

import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.LingeringPotionItem;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.SplashPotionItem;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import xyz.kohara.adjcore.ADJCore;

@Mixin(value={PotionItem.class})
public class PotionNameMixin
extends Item {
    public PotionNameMixin(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack stack) {
        PotionItem inst = (PotionItem)this;
        Component name = super.m_7626_(stack);
        String translated = I18n.m_118938_((String)((TranslatableContents)name.m_214077_()).m_237508_(), (Object[])((TranslatableContents)name.m_214077_()).m_237523_());
        String[] split = translated.replace("Lingering ", "").replace("Splash ", "").split(" of ");
        String type = null;
        TextColor color = null;
        if (inst instanceof SplashPotionItem) {
            type = "Throwable";
            color = TextColor.m_131270_((ChatFormatting)ChatFormatting.GOLD);
        } else if (inst instanceof LingeringPotionItem) {
            type = "Lingering";
            color = TextColor.m_131270_((ChatFormatting)ChatFormatting.LIGHT_PURPLE);
        }
        MutableComponent newName = Component.m_237119_();
        if (split.length >= 2) {
            String key = split[1];
            if (ADJCore.potionNameOverrides.containsKey(key)) {
                newName.m_130946_(ADJCore.potionNameOverrides.get(key));
            } else {
                newName.m_130946_(split[1]).m_130946_(" ").m_130946_(split[0]);
            }
        } else if (split.length == 1) {
            String key = split[0];
            newName.m_130946_(ADJCore.potionNameOverrides.getOrDefault(key, key));
        }
        if (type != null) {
            newName.m_130946_(" (").m_7220_((Component)Component.m_237113_((String)type).m_130948_(Style.f_131099_.m_131148_(color))).m_130946_(")");
        }
        return newName;
    }
}

