/*
 * Decompiled with CFR 0.152.
 */
package xyz.kohara.adjcore.mixins.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.LogoRenderer;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.WinScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import org.apache.commons.lang3.StringUtils;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xyz.kohara.adjcore.ADJCore;
import xyz.kohara.adjcore.misc.credits.Credits;
import xyz.kohara.adjcore.misc.credits.LoaderInfo;
import xyz.kohara.adjcore.misc.credits.ModInfo;

@Mixin(value={WinScreen.class})
public abstract class CreditScreenMixin
extends Screen {
    @Shadow
    private float f_169467_;
    @Shadow
    @Final
    private static String f_96867_;
    @Shadow
    @Final
    private LogoRenderer f_263706_;
    @Shadow
    private float f_96874_;
    @Shadow
    private IntSet f_96872_;
    @Shadow
    private List<FormattedCharSequence> f_96871_;
    @Shadow
    @Final
    private static ResourceLocation f_96866_;
    @Unique
    private static final Component adj$SECTION_HEADING;
    @Unique
    private static boolean adj$isPostCredits;

    @Shadow
    protected abstract void m_181397_(String var1);

    @Shadow
    protected abstract void m_169482_();

    @Shadow
    protected abstract void m_169472_(Component var1, boolean var2);

    @Shadow
    protected abstract void m_280337_(GuiGraphics var1);

    protected CreditScreenMixin(Component title) {
        super(title);
    }

    @Inject(method={"init()V"}, at={@At(value="INVOKE_ASSIGN", target="Ljava/util/List;size()I")})
    protected void initInvoke(CallbackInfo ci) {
        this.f_169467_ = 100.0f;
        adj$isPostCredits = false;
    }

    @Inject(method={"addPoemFile"}, at={@At(value="HEAD")}, cancellable=true)
    private void modifyPoemFile(Reader oldReader, CallbackInfo ci) throws IOException {
        int i;
        Object string;
        BufferedReader reader;
        if (adj$isPostCredits) {
            if (!Credits.Files.POST_CREDITS.exists()) {
                return;
            }
            reader = new BufferedReader(new FileReader(Credits.Files.POST_CREDITS.getFile(), StandardCharsets.UTF_8));
        } else {
            if (!Credits.Files.POEM.exists()) {
                return;
            }
            reader = new BufferedReader(new FileReader(Credits.Files.POEM.getFile(), StandardCharsets.UTF_8));
        }
        ci.cancel();
        BufferedReader bufferedReader = new BufferedReader(reader);
        RandomSource randomSource = RandomSource.m_216335_((long)8124371L);
        while ((string = bufferedReader.readLine()) != null) {
            string = ((String)string).replaceAll("PLAYERNAME", this.f_96541_.m_91094_().m_92546_());
            while ((i = ((String)string).indexOf(f_96867_)) != -1) {
                String string2 = ((String)string).substring(0, i);
                String string3 = ((String)string).substring(i + f_96867_.length());
                string = string2 + String.valueOf(ChatFormatting.WHITE) + String.valueOf(ChatFormatting.OBFUSCATED) + "XXXXXXXX".substring(0, randomSource.m_188503_(4) + 3) + string3;
            }
            this.m_181397_((String)string);
            if (adj$isPostCredits) {
                this.f_96872_.add(this.f_96871_.size());
            }
            this.m_169482_();
        }
        for (i = 0; i < (adj$isPostCredits ? 3 : 8); ++i) {
            this.m_169482_();
        }
        adj$isPostCredits = true;
    }

    @Inject(method={"addCreditsFile"}, at={@At(value="HEAD")}, cancellable=true)
    private void modifyCreditsFile(Reader oldReader, CallbackInfo ci) throws IOException {
        if (!Credits.Files.CREDITS.exists()) {
            return;
        }
        ci.cancel();
        BufferedReader reader = new BufferedReader(new FileReader(Credits.Files.CREDITS.getFile(), StandardCharsets.UTF_8));
        for (Object jsonElement : GsonHelper.m_144765_((Reader)reader)) {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            String string = jsonObject.get("section").getAsString();
            this.m_169472_((Component)Component.m_237113_((String)string).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW).m_131162_(Boolean.valueOf(true)).m_131136_(Boolean.valueOf(true))), true);
            this.m_169482_();
            this.m_169482_();
            for (JsonElement jsonElement2 : jsonObject.getAsJsonArray("disciplines")) {
                JsonObject jsonObject2 = jsonElement2.getAsJsonObject();
                String string2 = jsonObject2.get("discipline").getAsString();
                if (StringUtils.isNotEmpty((CharSequence)string2)) {
                    this.adj$addCreditTitle(string2);
                }
                for (JsonElement jsonElement3 : jsonObject2.getAsJsonArray("titles")) {
                    JsonObject jsonObject3 = jsonElement3.getAsJsonObject();
                    String string3 = jsonObject3.get("title").getAsString();
                    JsonArray jsonArray4 = jsonObject3.getAsJsonArray("names");
                    this.m_169472_((Component)Component.m_237113_((String)string3).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GRAY)), true);
                    this.m_169482_();
                    for (JsonElement jsonElement4 : jsonArray4) {
                        String string4 = jsonElement4.getAsString();
                        boolean addEmpty = this.adj$addPlayerTitle(string4);
                        this.m_169472_((Component)Component.m_237113_((String)this.adj$getPlayerSkin(string4)).m_130946_(string4).m_130940_(ChatFormatting.WHITE), true);
                        if (!addEmpty) continue;
                        this.m_169482_();
                    }
                    this.m_169482_();
                    this.m_169482_();
                }
            }
        }
        try {
            LoaderInfo loaderInfo = ADJCore.impl.getLoaderInfo();
            this.adj$addCreditTitle("Loader");
            this.adj$addCreditSection(loaderInfo.name(), Stream.concat(loaderInfo.authors().stream(), loaderInfo.contributors().stream()).toList());
            this.adj$addCreditTitle("Mods");
            try {
                for (ModInfo modInfo : ADJCore.impl.getMods()) {
                    this.adj$addCreditSection("[mod+" + modInfo.modId() + "] " + modInfo.modName(), Stream.concat(modInfo.authors().stream(), modInfo.contributors().stream()).toList());
                }
            }
            catch (Exception e) {
                ADJCore.LOGGER.error("Could not add mod credits", (Throwable)e);
            }
        }
        catch (Exception e) {
            ADJCore.LOGGER.error("Could not add loader credits", (Throwable)e);
        }
        this.m_169482_();
        this.m_169482_();
        this.m_169482_();
    }

    @Unique
    private String adj$getPlayerSkin(String name) {
        String playerName = name;
        if (Credits.NAME_TO_SKIN.containsKey(name)) {
            playerName = Credits.NAME_TO_SKIN.get(name);
        }
        return playerName.equals("NONE") ? "" : "[face:" + playerName + "] ";
    }

    @Unique
    private void adj$addCreditTitle(String title) {
        this.m_169472_(adj$SECTION_HEADING, true);
        this.m_169472_((Component)Component.m_237113_((String)title).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_131148_(TextColor.m_131268_((String)"#FFE136"))), true);
        this.m_169472_(adj$SECTION_HEADING, true);
        this.m_169482_();
        this.m_169482_();
    }

    @Unique
    private void adj$addCreditSection(String title, List<String> contributors) {
        this.m_169472_((Component)Component.m_237113_((String)title).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GRAY)), true);
        this.m_169482_();
        for (String author : contributors) {
            boolean addEmpty = this.adj$addPlayerTitle(author);
            this.m_169472_((Component)Component.m_237113_((String)this.adj$getPlayerSkin(author)).m_130946_(author).m_130940_(ChatFormatting.WHITE), true);
            if (!addEmpty) continue;
            this.m_169482_();
        }
        this.m_169482_();
        this.m_169482_();
    }

    @Unique
    private boolean adj$addPlayerTitle(String player) {
        if (Credits.PLAYER_TITLES == null) {
            return false;
        }
        boolean has = Credits.PLAYER_TITLES.containsKey(player);
        if (has) {
            this.m_169472_((Component)Component.m_237113_((String)ADJCore.toSmallUnicode(Credits.PLAYER_TITLES.get(player))).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GRAY)), true);
        }
        return has;
    }

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    public void modifyRender(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, CallbackInfo ci) {
        this.f_169467_ = Math.max(0.0f, this.f_169467_ + partialTick * this.f_96874_);
        this.m_280337_(guiGraphics);
        int i = this.f_96543_ / 2 - 128;
        int j = this.f_96544_ + 50;
        float f = -this.f_169467_;
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, f, 0.0f);
        this.f_263706_.m_280118_(guiGraphics, this.f_96543_, 1.0f, j);
        int k = j + 100;
        for (int l = 0; l < this.f_96871_.size(); ++l) {
            float g;
            if (l == this.f_96871_.size() - 1 && (g = (float)k + f - (float)(this.f_96544_ / 2 - 6)) < 0.0f) {
                guiGraphics.m_280168_().m_252880_(0.0f, -g, 0.0f);
            }
            if ((float)k + f + 12.0f + 8.0f > 0.0f && (float)k + f < (float)this.f_96544_) {
                FormattedCharSequence formattedCharSequence = this.f_96871_.get(l);
                if (this.f_96872_.contains(l)) {
                    guiGraphics.m_280364_(this.f_96547_, formattedCharSequence, i + 128, k, 0xFFFFFF);
                } else {
                    guiGraphics.m_280648_(this.f_96547_, formattedCharSequence, i, k, 0xFFFFFF);
                }
            }
            k += 12;
        }
        guiGraphics.m_280168_().m_85849_();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR);
        guiGraphics.m_280398_(f_96866_, 0, 0, 0, 0.0f, 0.0f, this.f_96543_, this.f_96544_, this.f_96543_, this.f_96544_);
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    static {
        adj$SECTION_HEADING = Component.m_237113_((String)"                                      ").m_130948_(Style.f_131099_.m_178522_(Boolean.valueOf(true)).m_131140_(ChatFormatting.WHITE).m_131136_(Boolean.valueOf(true)));
        adj$isPostCredits = false;
    }
}

