/*
 * Decompiled with CFR 0.152.
 */
package xyz.kohara.adjcore.mixins.ars;

import com.hollingsworth.arsnouveau.api.mana.IManaCap;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.common.items.SpellBook;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ModPotions;
import java.util.Map;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SpellResolver.class}, remap=false)
public class SpellCooldownMixin {
    @Shadow
    public SpellContext spellContext;
    @Unique
    private final Map<Integer, Integer> adj$spellCooldowns = Map.of(1, 9, 2, 7, 3, 5, 99, 5);

    @Inject(method={"expendMana"}, at={@At(value="TAIL")})
    private void addSpellCooldown(CallbackInfo ci) {
        LivingEntity livingEntity = this.spellContext.getUnwrappedCaster();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            livingEntity = this.spellContext.getCasterTool().m_41720_();
            if (livingEntity instanceof SpellBook) {
                SpellBook spellBook = (SpellBook)livingEntity;
                SpellTier tier = spellBook.getTier();
                int cooldown = this.adj$spellCooldowns.getOrDefault(tier.value, 20);
                player.m_36335_().m_41524_((Item)spellBook, cooldown);
                IManaCap mana = (IManaCap)CapabilityRegistry.getMana((LivingEntity)player).orElse(null);
                double i1 = 1.0 - mana.getCurrentMana() / (double)mana.getMaxMana();
                double regenDelay = 0.7 * (i1 * 240.0 + 45.0);
                if (player.m_21023_((MobEffect)ModPotions.MANA_REGEN_EFFECT.get())) {
                    regenDelay = Math.min(regenDelay, 20.0);
                }
                int delay = (int)Math.ceil(regenDelay / 3.0);
                player.adjcore$setManaRegenDelay(delay);
            }
        }
    }
}

