/*
 * Decompiled with CFR 0.152.
 */
package xyz.kohara.adjcore.mixins.ars;

import com.hollingsworth.arsnouveau.api.event.MaxManaCalcEvent;
import com.hollingsworth.arsnouveau.api.mana.IManaCap;
import com.hollingsworth.arsnouveau.api.perk.PerkAttributes;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.util.ManaUtil;
import com.hollingsworth.arsnouveau.setup.config.ServerConfig;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ModPotions;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xyz.kohara.adjcore.attributes.ModAttributes;

@Mixin(value={ManaUtil.class}, remap=false)
public class ReworkMaxManaProgression {
    @Shadow
    @Final
    static UUID MAX_MANA_MODIFIER;
    @Shadow
    @Final
    static UUID MANA_REGEN_MODIFIER;

    @Inject(method={"calcMaxMana"}, at={@At(value="HEAD")}, cancellable=true)
    private static void calcMaxMana(Player e, CallbackInfoReturnable<ManaUtil.Mana> cir) {
        cir.cancel();
        double rawMax = ((Integer)ServerConfig.INIT_MAX_MANA.get()).intValue();
        AttributeInstance manaAttribute = e.m_21051_((Attribute)PerkAttributes.MAX_MANA.get());
        if (manaAttribute != null) {
            AttributeModifier manaCache = manaAttribute.m_22111_(MAX_MANA_MODIFIER);
            if (manaCache == null || manaCache.m_22218_() != rawMax) {
                if (manaCache != null) {
                    manaAttribute.m_22130_(manaCache);
                }
                manaAttribute.m_22118_(new AttributeModifier(MAX_MANA_MODIFIER, "Mana Cache", rawMax, AttributeModifier.Operation.ADDITION));
            }
            rawMax = manaAttribute.m_22135_();
        }
        int max = (int)rawMax;
        MaxManaCalcEvent event = new MaxManaCalcEvent((LivingEntity)e, max);
        MinecraftForge.EVENT_BUS.post((Event)event);
        max = event.getMax();
        float reserve = event.getReserve();
        cir.setReturnValue((Object)new ManaUtil.Mana(max, reserve));
    }

    @Inject(method={"getManaRegen"}, at={@At(value="HEAD")}, cancellable=true)
    private static void getManaRegen(Player e, CallbackInfoReturnable<Double> cir) {
        if (e.adjcore$getManaRegenDelay() > 0) {
            cir.setReturnValue((Object)0.0);
        }
        double regenBonus = ((Integer)ServerConfig.INIT_MANA_REGEN.get()).intValue();
        AttributeInstance manaAttribute = e.m_21051_((Attribute)PerkAttributes.MANA_REGEN_BONUS.get());
        if (manaAttribute != null) {
            AttributeModifier manaCache = manaAttribute.m_22111_(MANA_REGEN_MODIFIER);
            if (manaCache == null || manaCache.m_22218_() != regenBonus) {
                if (manaCache != null) {
                    manaAttribute.m_22130_(manaCache);
                }
                manaAttribute.m_22118_(new AttributeModifier(MANA_REGEN_MODIFIER, "Mana Regen Cache", regenBonus, AttributeModifier.Operation.ADDITION));
            }
            regenBonus = manaAttribute.m_22135_();
        } else {
            cir.setReturnValue((Object)0.0);
        }
        Optional manaCapOptional = CapabilityRegistry.getMana((LivingEntity)e).resolve();
        if (manaCapOptional.isEmpty()) {
            cir.setReturnValue((Object)0.0);
            return;
        }
        IManaCap mana = (IManaCap)manaCapOptional.get();
        double stationaryBonus = 0.0;
        if (!e.f_267362_.m_267780_() || e.m_21023_((MobEffect)ModPotions.MANA_REGEN_EFFECT.get())) {
            stationaryBonus = (double)mana.getMaxMana() / 3.0;
        }
        double regenFactor = e.m_21023_((MobEffect)ModPotions.MANA_REGEN_EFFECT.get()) ? 1.0 : mana.getCurrentMana() / (double)mana.getMaxMana() * 0.8 + 0.2;
        double regen = ((double)mana.getMaxMana() / 3.0 + 1.0 + stationaryBonus + regenBonus * 5.0) * regenFactor * 1.15;
        cir.setReturnValue((Object)Math.ceil(regen / 3.0));
    }

    @Redirect(method={"getPlayerDiscounts"}, at=@At(value="INVOKE", target="Ljava/util/concurrent/atomic/AtomicInteger;get()I"))
    private static int applyPercentReductions(AtomicInteger instance, @Local(argsOnly=true) LivingEntity e, @Local(argsOnly=true) Spell spell) {
        int original = instance.get();
        if (!(e instanceof Player)) {
            return original;
        }
        Player player = (Player)e;
        double reduction = 0.0;
        AttributeInstance costReduction = player.m_21051_((Attribute)ModAttributes.MANA_COST_REDUCTION.get());
        if (costReduction != null) {
            reduction = costReduction.m_22135_();
        }
        double cost = spell.getCost();
        return (int)((double)original + cost * reduction);
    }

    @Inject(method={"getPlayerDiscounts"}, at={@At(value="HEAD")}, cancellable=true)
    private static void getPlayerDiscounts(LivingEntity e, Spell spell, ItemStack casterStack, CallbackInfoReturnable<Integer> cir) {
        if (e == null) {
            cir.setReturnValue((Object)0);
            return;
        }
        double reduction = 0.0;
        AttributeInstance costReduction = e.m_21051_((Attribute)ModAttributes.MANA_COST_REDUCTION.get());
        if (costReduction != null) {
            reduction = costReduction.m_22135_();
        }
        double cost = spell.getCost();
        cir.setReturnValue((Object)((int)(cost * reduction)));
    }
}

