/*
 * Decompiled with CFR 0.152.
 */
package xyz.kohara.adjcore.mixins.ars;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.item.ICasterTool;
import com.hollingsworth.arsnouveau.api.spell.ISpellCaster;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.util.ManaUtil;
import com.hollingsworth.arsnouveau.common.items.Glyph;
import com.hollingsworth.arsnouveau.common.spell.casters.ReactiveCaster;
import com.hollingsworth.arsnouveau.setup.registry.EnchantmentRegistry;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={ItemStack.class})
public class GlyphCostMixin {
    @Redirect(method={"getTooltipLines"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/Item;appendHoverText(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/Level;Ljava/util/List;Lnet/minecraft/world/item/TooltipFlag;)V"))
    public void appendHoverText(Item instance, ItemStack stack, Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        int cost;
        instance.m_7373_(stack, level, tooltipComponents, isAdvanced);
        if (ArsNouveau.proxy.getMinecraft() == null) {
            return;
        }
        Player player = ArsNouveau.proxy.getPlayer();
        if (player == null) {
            return;
        }
        if (instance instanceof Glyph) {
            Glyph glyph = (Glyph)instance;
            cost = glyph.spellPart.getCastingCost();
        } else if (instance instanceof ICasterTool) {
            ICasterTool casterTool = (ICasterTool)instance;
            ISpellCaster casterData = casterTool.getSpellCaster(stack);
            Spell spell = casterData.getSpell(casterData.getCurrentSlot());
            if (spell.isEmpty()) {
                return;
            }
            cost = spell.getCost() - ManaUtil.getPlayerDiscounts((LivingEntity)player, (Spell)spell, (ItemStack)stack);
        } else if (stack.getEnchantmentLevel((Enchantment)EnchantmentRegistry.REACTIVE_ENCHANTMENT.get()) > 0) {
            Spell casterData = new ReactiveCaster(stack).getSpell();
            if (casterData.isEmpty()) {
                return;
            }
            cost = casterData.getCost() - ManaUtil.getPlayerDiscounts((LivingEntity)player, (Spell)casterData, (ItemStack)stack);
        } else {
            return;
        }
        tooltipComponents.add((Component)Component.m_237113_((String)"M\u1d00\u0274\u1d00 C\u1d0fs\u1d1b: ").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_PURPLE)).m_130946_(String.valueOf(cost)));
    }
}

