/*
 * Decompiled with CFR 0.152.
 */
package xyz.kohara.adjcore.mixins;

import com.rosemods.heart_crystals.core.HCConfig;
import com.rosemods.heart_crystals.core.other.HCEvents;
import com.rosemods.heart_crystals.core.other.HCPlayerInfo;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={HCEvents.class}, remap=false)
public abstract class HCEventsMixin {
    @Inject(method={"onPlayerLoggedIn"}, at={@At(value="HEAD")}, cancellable=true)
    private static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event, CallbackInfo ci) {
        ci.cancel();
        Player player = event.getEntity();
        HCEventsMixin.adj$syncPlayerInfo(player);
        if (player != null) {
            HCPlayerInfo.PlayerHealthInfo info = HCPlayerInfo.getPlayerHealthInfo((Entity)player);
            int minimum = (Integer)HCConfig.COMMON.minimum.get();
            if (!info.healthSet) {
                HCEvents.setMaxHealthAttribute((int)(minimum * 20), (Player)player);
                player.m_21153_((float)(minimum * 20));
                info.healthSet = true;
                info.syncHealthInfo((Entity)player);
            } else if (info.heartCount < (Integer)HCConfig.COMMON.minimum.get()) {
                HCEvents.setMaxHealthAttribute((int)(minimum * 20), (Player)player);
                player.m_21153_((float)(minimum * 20));
                info.heartCount = minimum;
                info.syncHealthInfo((Entity)player);
            }
        }
    }

    @Inject(method={"onPlayerRespawn"}, at={@At(value="HEAD")}, cancellable=true)
    private static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event, CallbackInfo ci) {
        ci.cancel();
        Player player = event.getEntity();
        HCEventsMixin.adj$syncPlayerInfo(event.getEntity());
        if (player != null) {
            HCPlayerInfo.PlayerHealthInfo info = HCPlayerInfo.getPlayerHealthInfo((Entity)player);
            HCEvents.setMaxHealthAttribute((int)(info.heartCount * 20), (Player)player);
            player.m_21153_(Math.max((float)(info.heartCount * 20) / 2.0f, 100.0f));
        }
    }

    @Unique
    private static void adj$syncPlayerInfo(Player player) {
        if (player != null && !player.m_9236_().m_5776_()) {
            HCPlayerInfo.getPlayerHealthInfo((Entity)player).syncHealthInfo((Entity)player);
        }
    }
}

