/*
 * Decompiled with CFR 0.152.
 */
package xyz.kohara.adjcore.misc.capabilities;

import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import xyz.kohara.adjcore.misc.ModCapabilities;
import xyz.kohara.adjcore.misc.capabilities.IPlayerLoadouts;
import xyz.kohara.adjcore.misc.capabilities.PlayerLoadoutsProvider;

public class CapabilityEvents {
    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            event.addCapability(ResourceLocation.fromNamespaceAndPath((String)"adjcore", (String)"loadouts"), (ICapabilityProvider)new ICapabilitySerializable<CompoundTag>(){
                final IPlayerLoadouts inst = new PlayerLoadoutsProvider();

                @NotNull
                public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
                    return cap == ModCapabilities.PLAYER_LOADOUTS ? LazyOptional.of(() -> this.inst).cast() : LazyOptional.empty();
                }

                public CompoundTag serializeNBT() {
                    return this.inst.serializeNBT();
                }

                public void deserializeNBT(CompoundTag nbt) {
                    this.inst.deserializeNBT(nbt);
                }
            });
        }
    }

    @SubscribeEvent
    public static void clonePlayer(PlayerEvent.Clone event) {
        event.getOriginal().reviveCaps();
        event.getOriginal().getCapability(ModCapabilities.PLAYER_LOADOUTS).ifPresent(oldCap -> event.getEntity().getCapability(ModCapabilities.PLAYER_LOADOUTS).ifPresent(newCap -> newCap.deserializeNBT(oldCap.serializeNBT())));
    }
}

