/*
 * Decompiled with CFR 0.152.
 */
package xyz.kohara.adjcore.misc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class DelayedTaskScheduler {
    private static final Map<Integer, List<Runnable>> TASKS = new HashMap<Integer, List<Runnable>>();
    private static int tickCount = 0;

    private static void tick() {
        List<Runnable> runnables;
        if ((runnables = TASKS.remove(++tickCount)) != null) {
            runnables.forEach(Runnable::run);
        }
    }

    public static void schedule(Runnable task, int delay) {
        int executeTick = tickCount + delay;
        TASKS.computeIfAbsent(executeTick, k -> new ArrayList()).add(task);
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            DelayedTaskScheduler.tick();
        }
    }
}

