/*
 * Decompiled with CFR 0.152.
 */
package xyz.kohara.adjcore.entity;

import java.util.Map;
import java.util.Optional;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import xyz.kohara.adjcore.client.networking.ModMessages;
import xyz.kohara.adjcore.client.networking.packet.ShowRainbowMessageS2CPacket;
import xyz.kohara.adjcore.misc.ModCapabilities;
import xyz.kohara.adjcore.misc.capabilities.IPlayerLoadouts;

public class PlayerLoadouts {
    private static final Map<Integer, String> ARMOR_SLOTS = Map.of(0, "head", 1, "chest", 2, "legs", 3, "feet");

    public static void changeLoadout(ServerPlayer player, int targetLoadout) {
        player.getCapability(ModCapabilities.PLAYER_LOADOUTS).ifPresent(loadouts -> {
            int currentLoadout = loadouts.getCurrentLoadout();
            if (currentLoadout == 0) {
                loadouts.setCurrentLoadout(1);
                currentLoadout = 1;
            }
            if (currentLoadout == targetLoadout) {
                return;
            }
            PlayerLoadouts.saveCurrentLoadout(loadouts, PlayerLoadouts.loadoutID(currentLoadout), player);
            PlayerLoadouts.setPlayerEquipment(PlayerLoadouts.getOrCreateLoadout(loadouts, PlayerLoadouts.loadoutID(targetLoadout)), player);
            loadouts.setCurrentLoadout(targetLoadout);
            PlayerLoadouts.playSFX(player, targetLoadout);
        });
    }

    private static String loadoutID(int i) {
        return "adj.loadout_" + i;
    }

    private static CompoundTag getOrCreateLoadout(IPlayerLoadouts loadouts, String key) {
        CompoundTag existing = loadouts.getLoadout(key);
        if (existing.m_128456_()) {
            CompoundTag loadout = new CompoundTag();
            CompoundTag emptyItem = ItemStack.f_41583_.m_41739_(new CompoundTag());
            loadout.m_128365_("head", (Tag)emptyItem.m_6426_());
            loadout.m_128365_("chest", (Tag)emptyItem.m_6426_());
            loadout.m_128365_("legs", (Tag)emptyItem.m_6426_());
            loadout.m_128365_("feet", (Tag)emptyItem.m_6426_());
            loadout.m_128365_("curios", (Tag)new ListTag());
            loadouts.setLoadout(key, loadout);
            return loadout;
        }
        return existing;
    }

    private static void saveCurrentLoadout(IPlayerLoadouts parent, String key, ServerPlayer player) {
        CompoundTag loadout = new CompoundTag();
        for (int i = 0; i < player.m_150109_().f_35975_.size(); ++i) {
            ItemStack stack = player.m_150109_().m_36052_(i);
            CompoundTag stackTag = new CompoundTag();
            stack.m_41739_(stackTag);
            loadout.m_128365_(ARMOR_SLOTS.get(i), (Tag)stackTag);
        }
        ListTag curiosList = new ListTag();
        Optional curiosInv = CuriosApi.getCuriosInventory((LivingEntity)player).resolve();
        curiosInv.ifPresent(iCuriosItemHandler -> iCuriosItemHandler.getCurios().forEach((curioSlot, handler) -> {
            if (curioSlot.equals("accessory")) {
                IDynamicStackHandler stackHandler = handler.getStacks();
                for (int i = 0; i < stackHandler.getSlots(); ++i) {
                    ItemStack stack = stackHandler.getStackInSlot(i);
                    if (stack.m_41619_()) continue;
                    CompoundTag stackTag = new CompoundTag();
                    stack.m_41739_(stackTag);
                    stackTag.m_128405_("slot", i);
                    curiosList.add((Object)stackTag);
                }
            }
        }));
        loadout.m_128365_("curios", (Tag)curiosList);
        parent.setLoadout(key, loadout);
    }

    private static void setPlayerEquipment(CompoundTag loadoutData, ServerPlayer player) {
        for (int i = 0; i < player.m_150109_().f_35975_.size(); ++i) {
            player.m_150109_().f_35975_.set(i, (Object)ItemStack.m_41712_((CompoundTag)loadoutData.m_128469_(ARMOR_SLOTS.get(i))));
        }
        Optional curiosInv = CuriosApi.getCuriosInventory((LivingEntity)player).resolve();
        if (curiosInv.isPresent()) {
            ((ICuriosItemHandler)curiosInv.get()).getCurios().forEach((slotId, handler) -> {
                if (slotId.equals("accessory")) {
                    IDynamicStackHandler stacks = handler.getStacks();
                    for (int i = 0; i < stacks.getSlots(); ++i) {
                        stacks.setStackInSlot(i, ItemStack.f_41583_);
                    }
                }
            });
            ListTag curiosList = loadoutData.m_128437_("curios", 10);
            for (int i = 0; i < curiosList.size(); ++i) {
                CompoundTag stackTag = curiosList.m_128728_(i);
                int slot = stackTag.m_128451_("slot");
                ItemStack stack = ItemStack.m_41712_((CompoundTag)stackTag);
                curiosInv.ifPresent(iCuriosItemHandler -> iCuriosItemHandler.getCurios().forEach((curioSlot, handler) -> {
                    if (curioSlot.equals("accessory")) {
                        IDynamicStackHandler stackHandler = handler.getStacks();
                        stackHandler.setStackInSlot(slot, stack);
                    }
                }));
            }
        }
    }

    private static void playSFX(ServerPlayer player, int loadout) {
        RandomSource random = player.m_9236_().f_46441_;
        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11973_, SoundSource.PLAYERS, 0.8f, 0.8f + random.m_188501_() * 0.4f);
        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12087_, SoundSource.PLAYERS, 0.5f, 0.8f + random.m_188501_() * 0.4f);
        ModMessages.sendToPlayer(new ShowRainbowMessageS2CPacket((Component)Component.m_237113_((String)("Switched active loadout to Loadout " + loadout))), player);
        AABB box = player.m_20191_();
        for (int i = 0; i < 13; ++i) {
            double x = Mth.m_14139_((double)random.m_188500_(), (double)box.f_82288_, (double)box.f_82291_);
            double y = Mth.m_14139_((double)random.m_188500_(), (double)box.f_82289_, (double)box.f_82292_);
            double z = Mth.m_14139_((double)random.m_188500_(), (double)box.f_82290_, (double)box.f_82293_);
            ((ServerLevel)player.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123759_, x, y, z, 1, 0.0, 0.0, 0.0, 0.1);
        }
    }
}

