/*
 * Decompiled with CFR 0.152.
 */
package xyz.kohara.adjcore.effects.editor;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraftforge.registries.ForgeRegistries;
import xyz.kohara.adjcore.effects.editor.EffectEditorConfig;
import xyz.kohara.adjcore.mixins.effect.MobEffectAccessor;

public class EffectsEditor {
    private static Map<ResourceLocation, EffectEditorConfig.ConfigData> config;

    public static void loadConfig() {
        config = new HashMap<ResourceLocation, EffectEditorConfig.ConfigData>();
        config = EffectEditorConfig.parseConfig();
    }

    public static void edit() {
        EffectsEditor.loadConfig();
        for (MobEffect effect : BuiltInRegistries.f_256974_) {
            String[] name = effect.m_19481_().split("\\.");
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)name[1], (String)name[2]);
            if (!config.containsKey(id)) continue;
            EffectEditorConfig.ConfigData data = config.get(id);
            MobEffectAccessor accessor = (MobEffectAccessor)effect;
            Map<Attribute, AttributeModifier> oldAttr = accessor.getAttributeModifiers();
            Map<Object, Object> attributeModifierMap = !data.replace && !oldAttr.isEmpty() ? oldAttr : new HashMap();
            data.attributes.forEach(s -> {
                String[] entry = s.split(";");
                Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(ResourceLocation.parse((String)entry[0]));
                UUID uuid = UUID.nameUUIDFromBytes(effect.m_19481_().getBytes());
                AttributeModifier modifier = new AttributeModifier(uuid, effect.m_19481_(), Double.parseDouble(entry[1]), AttributeModifier.Operation.m_22236_((int)Integer.parseInt(entry[2])));
                attributeModifierMap.put(attribute, modifier);
            });
            accessor.setAttributeModifiers(attributeModifierMap);
        }
    }
}

