/*
 * Decompiled with CFR 0.152.
 */
package xyz.kohara.adjcore.effects.editor;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.io.FileReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public class EffectEditorConfig {
    private static final String CONFIG_PATH = "config/adjcore/effect_attributes.json";

    public static Map<ResourceLocation, ConfigData> parseConfig() {
        Gson gson = new Gson();
        HashMap<ResourceLocation, ConfigData> result = new HashMap<ResourceLocation, ConfigData>();
        try (FileReader reader = new FileReader(CONFIG_PATH);){
            Type type = new TypeToken<Map<String, ConfigData>>(){}.getType();
            Map rawMap = (Map)gson.fromJson((Reader)reader, type);
            System.out.println("[EffectEditorConfig] Loaded raw config map with " + rawMap.size() + " entries");
            for (Map.Entry entry : rawMap.entrySet()) {
                ResourceLocation effectId = ResourceLocation.parse((String)((String)entry.getKey()));
                ConfigData config = (ConfigData)entry.getValue();
                System.out.println("[EffectEditorConfig] Parsed: " + String.valueOf(effectId) + " => " + String.valueOf(config));
                result.put(effectId, config);
            }
        }
        catch (Exception e) {
            System.err.println("[EffectEditorConfig] Failed to load config: " + e.getMessage());
            e.printStackTrace();
        }
        return result;
    }

    public static class ConfigData {
        public boolean replace;
        public List<String> attributes;

        public String toString() {
            return "ConfigData{replace=" + this.replace + ", attributes=" + String.valueOf(this.attributes) + "}";
        }
    }

    public static class AttributeModifierEntry {
        public final ResourceLocation attribute;
        public final double value;

        public AttributeModifierEntry(String input) {
            String[] parts = input.split(";");
            if (parts.length != 2) {
                throw new IllegalArgumentException("Invalid attribute entry: " + input);
            }
            this.attribute = ResourceLocation.parse((String)parts[0]);
            this.value = Double.parseDouble(parts[1]);
        }

        public String toString() {
            return String.valueOf(this.attribute) + " -> " + this.value;
        }
    }
}

