/*
 * Decompiled with CFR 0.152.
 */
package xyz.kohara.adjcore.curio;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.event.CurioEquipEvent;
import top.theillusivec4.curios.api.event.DropRulesEvent;
import top.theillusivec4.curios.api.type.ISlotType;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import xyz.kohara.adjcore.Config;
import xyz.kohara.adjcore.misc.ModTags;

public class CurioControl {
    private static final String ACCESSORY_SLOT = (String)Config.CURIO_TYPE_TO_KEEP.get();
    private static List<TagKey<Item>> EXCLUSION_LIST;
    private static final Enchantment CURIO_SOULBOUND;

    @SubscribeEvent
    public static void onCurioEquipEvent(CurioEquipEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        Optional curios = CuriosApi.getCuriosInventory((LivingEntity)entity).resolve();
        if (curios.isEmpty()) {
            return;
        }
        if (((ICuriosItemHandler)curios.get()).isEquipped(event.getStack().m_41720_())) {
            event.setResult(Event.Result.DENY);
            return;
        }
        if (EXCLUSION_LIST == null) {
            CurioControl.generateExclusions();
        }
        for (ICurioStacksHandler curioStacksHandler : ((ICuriosItemHandler)curios.get()).getCurios().values()) {
            IDynamicStackHandler stackHandler = curioStacksHandler.getStacks();
            for (int i = 0; i < stackHandler.getSlots(); ++i) {
                ItemStack stack = stackHandler.getStackInSlot(i);
                for (TagKey<Item> tag : EXCLUSION_LIST) {
                    if (!event.getStack().m_204117_(tag) || !stack.m_204117_(tag)) continue;
                    event.setResult(Event.Result.DENY);
                    return;
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        Map slots = CuriosApi.getPlayerSlots((Player)event.getEntity());
        for (ISlotType slot : slots.values()) {
            String id = slot.getIdentifier();
            if (Objects.equals(id, ACCESSORY_SLOT) || Objects.equals(id, "back") || Objects.equals(id, "spellbook")) continue;
            CuriosApi.getSlotHelper().setSlotsForType(id, (LivingEntity)event.getEntity(), 0);
        }
    }

    @SubscribeEvent
    public static void onTagsUpdated(TagsUpdatedEvent event) {
        CurioControl.generateExclusions();
    }

    @SubscribeEvent
    public static void keepCurios(DropRulesEvent event) {
        event.addOverride(i -> !i.m_204117_(ModTags.CURIOS_DROPPED_ON_DEATH) || i.getEnchantmentLevel(CURIO_SOULBOUND) > 0, ICurio.DropRule.ALWAYS_KEEP);
    }

    public static void generateExclusions() {
        ArrayList<TagKey<Item>> exclusionList = new ArrayList<TagKey<Item>>();
        for (TagKey tagKey : BuiltInRegistries.f_257033_.m_203612_().map(Pair::getFirst).collect(Collectors.toSet())) {
            if (tagKey.f_203868_().toString().indexOf("adjcore:curio_exclusions/") != 0) continue;
            exclusionList.add((TagKey<Item>)tagKey);
        }
        EXCLUSION_LIST = exclusionList;
    }

    static {
        CURIO_SOULBOUND = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(ResourceLocation.parse((String)((String)Config.SOULBOUND_FOR_CURIOS.get())));
    }
}

