/*
 * Decompiled with CFR 0.152.
 */
package xyz.kohara.adjcore.combat;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import xyz.kohara.adjcore.client.networking.ModMessages;
import xyz.kohara.adjcore.client.networking.packet.DamageIndicatorS2CPacket;
import xyz.kohara.adjcore.misc.events.ADJHurtEvent;

public class DamageIndicators {
    private void showIndicator(Entity entity, double x, double y, double z, float amount, int type) {
        double maxDistance = 48.0;
        entity.m_9236_().m_7654_().m_6846_().m_11314_().forEach(player -> {
            if (player.m_20280_(entity) <= Math.pow(maxDistance, 2.0)) {
                Vec3 pos = this.offsetTowardsViewer(entity, (Entity)player, 0.66);
                ModMessages.sendToPlayer(new DamageIndicatorS2CPacket(pos.f_82479_, pos.f_82480_, pos.f_82481_, amount, type), player);
            }
        });
    }

    private Vec3 offsetTowardsViewer(Entity entity, Entity viewer, double forwardDistance) {
        Vec3 direction = entity.m_20182_().m_82546_(viewer.m_20182_()).m_82541_().m_82490_(-1.0);
        Vec3 base = new Vec3(entity.m_20185_(), entity.m_20186_() + (double)entity.m_20192_(), entity.m_20189_());
        double spread = 0.33;
        double dx = direction.f_82479_ * forwardDistance + (Math.random() * (spread * 2.0) - spread);
        double dy = direction.f_82480_ * forwardDistance + (Math.random() * (spread * 2.0) - spread);
        double dz = direction.f_82481_ * forwardDistance + (Math.random() * (spread * 2.0) - spread);
        return base.m_82520_(dx, dy, dz);
    }

    @SubscribeEvent
    public void showDamageParticle(ADJHurtEvent event) {
        Entity victim = event.getVictim();
        LivingEntity attacker = event.getAttacker();
        int type = Type.DAMAGE_ENTITY.get();
        if (victim instanceof ServerPlayer) {
            type = Type.DAMAGE_PLAYER.get();
        } else if (event.isCritical()) {
            type = Type.CRIT.get();
        }
        double x = victim.m_20185_();
        double y = victim.m_20186_() + (double)victim.m_20192_();
        double z = victim.m_20189_();
        this.showIndicator(victim, x, y, z, event.getDamage(), type);
    }

    @SubscribeEvent
    public void onEntityHeal(LivingHealEvent event) {
        LivingEntity entity = event.getEntity();
        if (!entity.m_9236_().m_5776_() && entity.m_21223_() != entity.m_21233_() && event.getAmount() > 2.0f) {
            double x = entity.m_20185_();
            double y = entity.m_20186_() + (double)entity.m_20192_();
            double z = entity.m_20189_();
            this.showIndicator((Entity)entity, x, y, z, event.getAmount(), Type.HEAL.get());
        }
    }

    public static enum Type {
        DAMAGE_ENTITY(0),
        DAMAGE_PLAYER(1),
        HEAL(2),
        CRIT(3);

        private final int type;

        private Type(int type) {
            this.type = type;
        }

        public int get() {
            return this.type;
        }
    }
}

