/*
 * Decompiled with CFR 0.152.
 */
package xyz.kohara.adjcore.combat;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import dev.shadowsoffire.attributeslib.AttributesLib;
import dev.shadowsoffire.attributeslib.api.ALObjects;
import dev.shadowsoffire.attributeslib.packet.CritParticleMessage;
import dev.shadowsoffire.placebo.network.PacketDistro;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.ForgeRegistries;
import xyz.kohara.adjcore.Config;
import xyz.kohara.adjcore.attributes.ModAttributes;
import xyz.kohara.adjcore.misc.events.ADJHurtEvent;

public class DamageHandler {
    private static int INVUL_TIME;
    private static final List<TagKey<DamageType>> DISALLOWED_TAGS;
    private static final Supplier<Double> VARIATION;
    private static final Supplier<Float> MIN_DAMAGE;
    private static final Supplier<Float> ARMOR_POINT_FACTOR;
    private static final Supplier<Float> ARMOR_POINT_FACTOR_ENTITY;
    private static final String PATH = "config/adjcore/damage_multipliers.json";
    public static Map<String, Double> MULTIPLIERS;
    public static Map<String, IFrameConfig> IFRAMES;
    public static final String IFRAMES_PATH = "config/adjcore/iframes.json";

    public static void setInvulTime(LivingEntity entity, int time) {
        entity.f_19802_ = time * 2;
        entity.f_20916_ = entity.f_20917_ = time;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onLivingKnockback(LivingKnockBackEvent event) {
        LivingEntity entity = event.getEntity();
        int cooldown = entity.adjcore$getKnockbackCooldown();
        if (cooldown > 0) {
            float s = event.getStrength();
            s = Math.max(0.0f, s - s * (float)cooldown / 15.0f);
            event.setStrength(s);
        } else if (cooldown == 0) {
            entity.adjcore$setKnockbackCooldown(INVUL_TIME != 0 ? INVUL_TIME * 2 : 5);
        }
        DamageHandler.setInvulTime(entity, INVUL_TIME);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void adjustIFrames(LivingHurtEvent event) {
        DamageSource source = event.getSource();
        LivingEntity entity = event.getEntity();
        Entity attacker = source.m_7639_();
        int finalIFrames = -1;
        for (String id : IFRAMES.keySet()) {
            String attackerId;
            IFrameConfig cfg = IFRAMES.get(id);
            if (id.startsWith("#")) {
                String attackerId2;
                TagKey damageTypeTag = TagKey.m_203882_((ResourceKey)Registries.f_268580_, (ResourceLocation)ResourceLocation.parse((String)id.substring(1)));
                if (!source.m_269533_(damageTypeTag)) continue;
                finalIFrames = cfg.iframes;
                if (attacker == null || !cfg.overrides.containsKey(attackerId2 = ForgeRegistries.ENTITY_TYPES.getKey((Object)attacker.m_6095_()).toString())) continue;
                finalIFrames = cfg.overrides.get(attackerId2);
                continue;
            }
            if (!source.m_276093_(ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)ResourceLocation.parse((String)id)))) continue;
            finalIFrames = cfg.iframes;
            if (attacker == null || !cfg.overrides.containsKey(attackerId = ForgeRegistries.ENTITY_TYPES.getKey((Object)attacker.m_6095_()).toString())) break;
            finalIFrames = cfg.overrides.get(attackerId);
            break;
        }
        if (finalIFrames < 0) {
            finalIFrames = 10;
        }
        INVUL_TIME = finalIFrames;
        DamageHandler.setInvulTime(entity, INVUL_TIME);
    }

    private static float getValue(LivingEntity entity, Attribute attribute) {
        AttributeInstance instance = entity.m_21051_(attribute);
        return instance != null ? (float)instance.m_22135_() : 0.0f;
    }

    public static void loadConfig() {
        Gson gson = new Gson();
        Type type = new TypeToken<Map<String, Double>>(){}.getType();
        if (!Files.exists(Path.of(PATH, new String[0]), new LinkOption[0])) {
            return;
        }
        try (FileReader reader = new FileReader(PATH);){
            MULTIPLIERS = (Map)gson.fromJson((Reader)reader, type);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void loadIFrameConfig() {
        Gson gson = new Gson();
        Type type = new TypeToken<Map<String, IFrameConfig>>(){}.getType();
        if (!Files.exists(Path.of(IFRAMES_PATH, new String[0]), new LinkOption[0])) {
            return;
        }
        try (FileReader reader = new FileReader(IFRAMES_PATH);){
            IFRAMES = (Map)gson.fromJson((Reader)reader, type);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void handleLivingHurt(LivingHurtEvent event) {
        LivingEntity le;
        LivingEntity livingAttacker;
        float baseAmount;
        DamageSource source = event.getSource();
        LivingEntity entity = event.getEntity();
        Entity attackerEntity = source.m_7639_();
        float finalAmount = baseAmount = event.getAmount();
        for (String id : MULTIPLIERS.keySet()) {
            if (id.startsWith("#")) {
                TagKey damageTypeTag = TagKey.m_203882_((ResourceKey)Registries.f_268580_, (ResourceLocation)ResourceLocation.parse((String)id.substring(1)));
                if (!source.m_269533_(damageTypeTag)) continue;
                finalAmount = (float)((double)finalAmount * MULTIPLIERS.get(id));
                continue;
            }
            if (!source.m_276093_(ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)ResourceLocation.parse((String)id)))) continue;
            finalAmount = baseAmount;
            finalAmount = (float)((double)finalAmount * MULTIPLIERS.get(id));
            break;
        }
        if (DISALLOWED_TAGS.stream().noneMatch(arg_0 -> ((DamageSource)source).m_269533_(arg_0))) {
            LivingEntity attacker;
            AttributeInstance luck;
            double min = 1.0 - VARIATION.get();
            double max = 1.0 + VARIATION.get();
            double multiplier = min + Math.random() * (max - min);
            if (attackerEntity instanceof LivingEntity && (luck = (attacker = (LivingEntity)attackerEntity).m_21051_(Attributes.f_22286_)) != null) {
                int luckValue = (int)Math.abs(luck.m_22135_());
                for (int i = 0; i < luckValue; ++i) {
                    if (Math.random() < 0.5) continue;
                    double test = min + Math.random() * (max - min);
                    multiplier = luck.m_22135_() > 0.0 ? Math.max(multiplier, test) : Math.min(multiplier, test);
                }
            }
            finalAmount *= (float)multiplier;
        }
        boolean isCrit = false;
        double critChance = 0.0;
        float critDmg = 0.0f;
        float critMult = 1.0f;
        LivingEntity livingEntity = livingAttacker = attackerEntity instanceof LivingEntity ? (le = (LivingEntity)attackerEntity) : null;
        if (livingAttacker != null) {
            critChance = livingAttacker.m_21133_((Attribute)ALObjects.Attributes.CRIT_CHANCE.get());
            RandomSource rand = event.getEntity().m_217043_();
            for (critDmg = (float)livingAttacker.m_21133_((Attribute)ALObjects.Attributes.CRIT_DAMAGE.get()); (double)rand.m_188501_() <= critChance && critDmg > 1.0f; critDmg *= 0.85f) {
                critChance -= 1.0;
                critMult *= critDmg;
            }
            event.setAmount(finalAmount *= critMult);
            if (critMult > 1.0f) {
                isCrit = true;
                if (!livingAttacker.m_9236_().f_46443_) {
                    PacketDistro.sendToTracking((SimpleChannel)AttributesLib.CHANNEL, (Object)new CritParticleMessage(event.getEntity().m_19879_()), (ServerLevel)((ServerLevel)livingAttacker.m_9236_()), (BlockPos)event.getEntity().m_20183_());
                }
            }
        }
        if (!source.m_269533_(DamageTypeTags.f_268630_)) {
            finalAmount *= 1.0f - DamageHandler.getValue(entity, (Attribute)ModAttributes.DAMAGE_REDUCTION.get());
            if (source.m_269533_(DamageTypeTags.f_268524_)) {
                finalAmount *= 1.0f - DamageHandler.getValue(entity, (Attribute)ModAttributes.PROJECTILE_DAMAGE_REDUCTION.get());
            }
        }
        if (!source.m_269533_(DamageTypeTags.f_268490_)) {
            int armorPoints = (int)DamageHandler.getValue(entity, Attributes.f_22284_);
            int armorToughness = (int)DamageHandler.getValue(entity, Attributes.f_22285_);
            if (attackerEntity instanceof LivingEntity) {
                LivingEntity attacker = (LivingEntity)attackerEntity;
                int armorPierce = (int)DamageHandler.getValue(attacker, (Attribute)ALObjects.Attributes.ARMOR_PIERCE.get());
                float armorShred = Math.max(1.0f - DamageHandler.getValue(attacker, (Attribute)ALObjects.Attributes.ARMOR_SHRED.get()), 0.0f);
                armorPierce = Math.max(0, armorPierce - armorToughness);
                armorPoints = Math.max(Math.round((float)armorPoints * armorShred) - armorPierce, 0);
            }
            float factor = (entity instanceof Player ? ARMOR_POINT_FACTOR.get() : ARMOR_POINT_FACTOR_ENTITY.get()).floatValue();
            finalAmount = Math.max(MIN_DAMAGE.get().floatValue(), finalAmount - (float)armorPoints / factor);
        }
        finalAmount = Math.max(isCrit ? (float)Math.ceil(finalAmount) : (float)Math.round(finalAmount), MIN_DAMAGE.get().floatValue());
        event.setAmount(finalAmount);
        ADJHurtEvent eventHook = new ADJHurtEvent(livingAttacker, (Entity)event.getEntity(), baseAmount, finalAmount, isCrit, (float)critChance, critMult);
        MinecraftForge.EVENT_BUS.post((Event)eventHook);
    }

    static {
        DISALLOWED_TAGS = List.of(DamageTypeTags.f_268490_, DamageTypeTags.f_268630_, DamageTypeTags.f_268437_, DamageTypeTags.f_268738_);
        VARIATION = () -> (Double)Config.RANDOM_DAMAGE_VARIATION.get() / 100.0;
        MIN_DAMAGE = () -> Float.valueOf(((Double)Config.MIN_DAMAGE_TAKEN.get()).floatValue());
        ARMOR_POINT_FACTOR = () -> Float.valueOf(((Double)Config.ARMOR_POINT_REDUCTION_FACTOR.get()).floatValue());
        ARMOR_POINT_FACTOR_ENTITY = () -> Float.valueOf(((Double)Config.ARMOR_POINT_REDUCTION_FACTOR_ENTITY.get()).floatValue());
        MULTIPLIERS = new HashMap<String, Double>();
        IFRAMES = new HashMap<String, IFrameConfig>();
        DamageHandler.loadConfig();
        DamageHandler.loadIFrameConfig();
    }

    public static class IFrameConfig {
        public int iframes;
        public Map<String, Integer> overrides = new HashMap<String, Integer>();
    }
}

