/*
 * Decompiled with CFR 0.152.
 */
package xyz.kohara.adjcore.client.tooltip;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import xyz.kohara.adjcore.ADJCore;
import xyz.kohara.adjcore.client.tooltip.SpecialInfoOverrides;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="adjcore", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SpecialInfoTooltips {
    private static final Set<Item> MATERIAL_ITEMS = new HashSet<Item>();
    private static final Map<String, String> defaultTraitTexts = Map.of("can_be_placed", "Can be placed", "material", "Material", "equipable", "Equipable", "consumable", "Consumable");

    private static void createIngredientCache() {
        Minecraft mc;
        if (MATERIAL_ITEMS.isEmpty() && (mc = Minecraft.m_91087_()).m_91403_() != null) {
            mc.m_91403_().m_105141_().m_44051_().forEach(recipe -> recipe.m_7527_().forEach(ing -> {
                for (ItemStack ex : ing.m_43908_()) {
                    MATERIAL_ITEMS.add(ex.m_41720_());
                }
            }));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void editTooltip(ItemTooltipEvent event) {
        boolean isCurio;
        ItemStack stack = event.getItemStack();
        Item item = stack.m_41720_();
        ArrayList<String> traits = new ArrayList<String>();
        if (item.m_41472_()) {
            traits.add(defaultTraitTexts.get("consumable"));
        }
        if (item instanceof BlockItem) {
            traits.add(defaultTraitTexts.get("can_be_placed"));
        }
        EquipmentSlot slot = LivingEntity.m_147233_((ItemStack)stack);
        boolean bl = isCurio = !CuriosApi.getCuriosHelper().getCurioTags(item).isEmpty();
        if (item instanceof Equipable || slot != EquipmentSlot.MAINHAND && slot != EquipmentSlot.OFFHAND || isCurio) {
            traits.add(defaultTraitTexts.get("equipable"));
        }
        if (MATERIAL_ITEMS.isEmpty()) {
            SpecialInfoTooltips.createIngredientCache();
        }
        if (MATERIAL_ITEMS.contains(item)) {
            traits.add(defaultTraitTexts.get("material"));
        }
        for (String defaultTrait : SpecialInfoOverrides.defaultTraits) {
            SpecialInfoOverrides.OverrideEntry oE = SpecialInfoOverrides.getDefaultOverrideFor(item, defaultTrait);
            if (oE == null) continue;
            if (oE.shouldRemove()) {
                traits.remove(defaultTraitTexts.get(defaultTrait));
                continue;
            }
            traits.add(defaultTraitTexts.get(defaultTrait));
        }
        SpecialInfoOverrides.OverrideEntry oE = SpecialInfoOverrides.getCustomOverrideFor(item);
        if (oE != null && oE.getNames() != null) {
            traits.addAll(oE.getNames());
        }
        if (!traits.isEmpty()) {
            int i;
            ArrayList<MutableComponent> lines = new ArrayList<MutableComponent>();
            MutableComponent infoLine = Component.m_237119_();
            int count = 0;
            int total = traits.size();
            for (i = 0; i < total; ++i) {
                boolean isLastOverall;
                String trait = (String)traits.get(i);
                infoLine.m_7220_((Component)Component.m_237113_((String)ADJCore.toSmallUnicode(trait)).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(false)).m_131140_(ChatFormatting.GRAY)));
                boolean isLastInLine = ++count == 3;
                boolean bl2 = isLastOverall = i == total - 1;
                if (!isLastInLine && !isLastOverall) {
                    infoLine.m_7220_((Component)Component.m_237113_((String)" | ").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GRAY).m_131136_(Boolean.valueOf(true))));
                }
                if (!isLastInLine && !isLastOverall) continue;
                lines.add(infoLine);
                infoLine = Component.m_237119_();
                count = 0;
            }
            for (i = lines.size() - 1; i >= 0; --i) {
                event.getToolTip().add(1, (Component)lines.get(i));
            }
        }
    }
}

