/*
 * Decompiled with CFR 0.152.
 */
package xyz.kohara.adjcore.client.tooltip;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
public class SpecialInfoOverrides {
    private static final String folder = "config/adjcore/item_traits_overrides/";
    public static final List<String> defaultTraits = List.of("consumable", "can_be_placed", "material", "equipable");
    private static final Map<String, Set<String>> DEFAULT_OVERRIDES = new HashMap<String, Set<String>>();
    private static final Map<String, Set<String>> CUSTOM_OVERRIDES = new HashMap<String, Set<String>>();

    private static String configPath(String name) {
        return "config/adjcore/item_traits_overrides/default/" + name + ".txt";
    }

    @Nullable
    public static OverrideEntry getDefaultOverrideFor(Item item, String category) {
        if (!defaultTraits.contains(category)) {
            return null;
        }
        String id = ForgeRegistries.ITEMS.getKey((Object)item).toString();
        if (DEFAULT_OVERRIDES.containsKey(category)) {
            Set<String> entries = DEFAULT_OVERRIDES.get(category);
            String override = null;
            for (String entry : entries) {
                boolean pseudoRegex = false;
                if (entry.startsWith("/")) {
                    pseudoRegex = true;
                    entry = entry.substring(1);
                }
                String check = entry;
                if (entry.startsWith("-")) {
                    check = check.substring(1);
                }
                if ((!id.contains(check) || !pseudoRegex) && !id.equals(check)) continue;
                override = entry;
                break;
            }
            if (override == null) {
                return null;
            }
            return new OverrideEntry(category, override.startsWith("-"), null);
        }
        return null;
    }

    @Nullable
    public static OverrideEntry getCustomOverrideFor(Item item) {
        String id = ForgeRegistries.ITEMS.getKey((Object)item).toString();
        HashSet<String> customTraits = new HashSet<String>();
        block0: for (String name : CUSTOM_OVERRIDES.keySet()) {
            for (String s : CUSTOM_OVERRIDES.get(name)) {
                boolean pseudoRegex = false;
                if (s.startsWith("/")) {
                    pseudoRegex = true;
                    s = s.substring(1);
                }
                if ((!id.contains(s) || !pseudoRegex) && !id.equals(s)) continue;
                customTraits.add(name);
                continue block0;
            }
        }
        return customTraits.isEmpty() ? null : new OverrideEntry(id, null, customTraits);
    }

    static {
        for (String defaultTrait : defaultTraits) {
            File config = new File(SpecialInfoOverrides.configPath(defaultTrait));
            HashSet<String> entries = new HashSet<String>();
            try {
                if (!config.exists()) {
                    config.createNewFile();
                }
                Scanner reader = new Scanner(config);
                while (reader.hasNext()) {
                    String line = reader.nextLine();
                    entries.add(line);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            DEFAULT_OVERRIDES.put(defaultTrait, entries);
        }
        File[] files = new File(folder).listFiles((dir, name) -> name.toLowerCase().endsWith(".txt"));
        if (files != null) {
            for (File file : files) {
                String name2 = null;
                HashSet<String> entries = new HashSet<String>();
                try {
                    Scanner reader = new Scanner(file);
                    int i = 0;
                    while (reader.hasNext()) {
                        String line = reader.nextLine();
                        if (i == 0) {
                            name2 = line;
                        } else {
                            entries.add(line);
                        }
                        ++i;
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                if (name2 == null) continue;
                CUSTOM_OVERRIDES.put(name2, entries);
            }
        }
    }

    public record OverrideEntry(String entry, @Nullable Boolean remove, @Nullable Set<String> names) {
        public boolean shouldRemove() {
            return this.remove != null ? this.remove : false;
        }

        public String getName() {
            return this.entry;
        }

        public Set<String> getNames() {
            return this.names;
        }
    }
}

