/*
 * Decompiled with CFR 0.152.
 */
package xyz.kohara.adjcore.client.particle;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import xyz.kohara.adjcore.client.particle.ModParticles;

public class DamageParticle
extends Particle {
    private static final List<Float> POSITIONS = new ArrayList<Float>(Arrays.asList(Float.valueOf(0.0f), Float.valueOf(-0.25f), Float.valueOf(0.12f), Float.valueOf(-0.12f), Float.valueOf(0.25f)));
    private final Font fontRenderer;
    private final Component text;
    private final List<Color> color;
    private float fadeout;
    private float prevFadeout;
    private float visualDY;
    private float visualDX;
    private final int type;
    private float maxRotation;
    private float rotationSpeed;
    private float rotation;

    public DamageParticle(ClientLevel clientLevel, double x, double y, double z, double amount, double type, double unused) {
        super(clientLevel, x, y, z);
        this.fontRenderer = Minecraft.m_91087_().f_91062_;
        this.fadeout = 0.0f;
        this.prevFadeout = 0.0f;
        this.visualDY = 0.0f;
        this.visualDX = 0.0f;
        this.f_107225_ = 60;
        this.type = (int)type;
        List<List<Color>> COLORS = List.of(List.of(Color.decode("#F58E27"), Color.decode("#FAAE64")), List.of(Color.decode("#9C0909"), Color.decode("#E33B3B")), List.of(Color.decode("#3BE346"), Color.decode("#7EE686")), List.of(Color.decode("#FF3300"), Color.decode("#FF7E42")));
        this.color = COLORS.get(this.type);
        this.f_107216_ = 1.0;
        int number = (int)Math.abs(amount);
        MutableComponent text = Component.m_237113_((String)String.valueOf(number));
        if (this.type == 3) {
            text.m_130946_("!");
            text.m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)));
        }
        this.text = text;
        this.f_107215_ = POSITIONS.get(ThreadLocalRandom.current().nextInt(POSITIONS.size())).floatValue();
        this.rotationSpeed = 0.1f;
        if (this.type == 3) {
            this.maxRotation = 22.5f;
            this.rotationSpeed *= 1.5f;
        } else {
            this.maxRotation = 15.0f;
        }
    }

    public void m_5744_(@NotNull VertexConsumer consumer, Camera camera, float partialTicks) {
        RenderSystem.disableDepthTest();
        Vec3 cameraPos = camera.m_90583_();
        float particleX = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_) - cameraPos.m_7096_());
        float particleY = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_) - cameraPos.m_7098_());
        float particleZ = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_) - cameraPos.m_7094_());
        PoseStack poseStack = new PoseStack();
        poseStack.m_85836_();
        poseStack.m_252880_(particleX, particleY, particleZ);
        double distanceFromCam = new Vec3((double)particleX, (double)particleY, (double)particleZ).m_82553_();
        float fadeout = Mth.m_14179_((float)partialTicks, (float)this.prevFadeout, (float)this.fadeout);
        float defScale = this.type == 3 ? 0.0125f : 0.01f;
        float scale = (float)((double)defScale * distanceFromCam);
        poseStack.m_252781_(camera.m_253121_());
        poseStack.m_252880_(0.0f, this.f_107222_ / 2.0f, 0.0f);
        poseStack.m_252781_(new Quaternionf().rotateZ((float)Math.toRadians(this.rotation)));
        poseStack.m_252880_(0.0f, -this.f_107222_ / 2.0f, 0.0f);
        poseStack.m_85841_(-scale, -scale, scale);
        poseStack.m_85837_(0.0, 4.0 * (double)(1.0f - fadeout), 0.0);
        poseStack.m_85841_(fadeout, fadeout, fadeout);
        poseStack.m_85837_(0.0, -distanceFromCam / 10.0, 0.0);
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        float x1 = 0.5f - (float)this.fontRenderer.m_92852_((FormattedText)this.text) / 2.0f;
        Objects.requireNonNull(this.fontRenderer);
        float y1 = 0.5f - 9.0f;
        int color = this.flashColor(this.color.get(0), this.color.get(1));
        this.renderNumber(this.text, poseStack, x1, y1, color, buffer);
        buffer.m_109911_();
        poseStack.m_85849_();
    }

    private void renderNumber(Component text, PoseStack poseStack, float x, float y, int color, MultiBufferSource.BufferSource buffer) {
        int light = 0xF000F0;
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        this.fontRenderer.m_272077_(text, x, y, color, false, matrix, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, light);
        int darkColor = DamageParticle.darken(color, 0.75);
        float[][] offsets = new float[][]{{1.0f, 0.0f}, {-1.0f, 0.0f}, {0.0f, 1.0f}, {0.0f, -1.0f}};
        poseStack.m_85837_(0.0, 0.0, 0.03);
        for (float[] o : offsets) {
            this.fontRenderer.m_272077_(text, x + o[0], y + o[1], darkColor, false, matrix, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, light);
        }
        poseStack.m_85837_(0.0, 0.0, -0.03);
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        } else {
            this.prevFadeout = this.fadeout;
            float fadeOutLength = 6.0f;
            float fadeInLength = 2.0f;
            float fadeIn = Math.min(1.0f, (float)this.f_107224_ / fadeInLength);
            float fadeOut = (float)this.f_107224_ > (float)this.f_107225_ - fadeOutLength ? (float)(this.f_107225_ - this.f_107224_) / fadeOutLength : 1.0f;
            this.fadeout = fadeIn * fadeOut;
            float oscillation = (float)Math.sin((float)this.f_107224_ * this.rotationSpeed);
            this.rotation = oscillation * this.maxRotation;
            this.visualDY += (float)this.f_107216_;
            this.visualDX += (float)this.f_107215_;
            if (Math.sqrt(Mth.m_144952_((double)((double)this.visualDX * 1.5)) + (double)Mth.m_14207_((float)(this.visualDY - 1.0f))) < 0.9) {
                this.f_107216_ /= 2.0;
            } else {
                this.f_107216_ = 0.0;
                this.f_107215_ = 0.0;
            }
        }
    }

    public int flashColor(Color c1, Color c2) {
        float speed = 0.56666f;
        float t = (float)(Math.sin((float)this.f_107224_ * speed) * 0.5 + 0.5);
        int r = (int)((float)c1.getRed() + (float)(c2.getRed() - c1.getRed()) * t);
        int g = (int)((float)c1.getGreen() + (float)(c2.getGreen() - c1.getGreen()) * t);
        int b = (int)((float)c1.getBlue() + (float)(c2.getBlue() - c1.getBlue()) * t);
        return new Color(r, g, b).getRGB();
    }

    public static int darken(int colorInt, double amount) {
        double factor = 1.0 - amount;
        int alpha = colorInt >> 24 & 0xFF;
        int red = colorInt >> 16 & 0xFF;
        int green = colorInt >> 8 & 0xFF;
        int blue = colorInt & 0xFF;
        red = (int)((double)red * factor);
        green = (int)((double)green * factor);
        blue = (int)((double)blue * factor);
        red = Math.max(0, Math.min(255, red));
        green = Math.max(0, Math.min(255, green));
        blue = Math.max(0, Math.min(255, blue));
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    @NotNull
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107433_;
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        public Factory(SpriteSet spriteSet) {
        }

        @SubscribeEvent
        public static void register(RegisterParticleProvidersEvent event) {
            event.registerSpriteSet((ParticleType)ModParticles.DAMAGE_PARTICLE.get(), Factory::new);
        }

        public Particle createParticle(@NotNull SimpleParticleType typeIn, @NotNull ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new DamageParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed);
        }
    }
}

