/*
 * Decompiled with CFR 0.152.
 */
package xyz.kohara.adjcore.client.music;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.sounds.MusicManager;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.registries.ForgeRegistries;
import xyz.kohara.adjcore.ADJCore;
import xyz.kohara.adjcore.client.music.JukeboxTracker;
import xyz.kohara.adjcore.client.music.MusicConfig;
import xyz.kohara.adjcore.mixins.music.MusicManagerAccessor;

public class MusicPlayer {
    public static Music resolvedMenu;
    public static Map<String, ResolvedEntry> resolvedDefaults;
    public static Map<String, ResolvedEntry> resolvedBiomes;
    public static Map<String, ResolvedBossMusic> resolvedBosses;
    private static final Predicate<WitherBoss> WITHER_PREDICATE;
    private static final Predicate<LivingEntity> ENTITY_PREDICATE;
    private static Music[] bossMusic;
    public static boolean isStopping;
    public static boolean isFadingOut;
    public static Music CURRENT_TRACK;

    public static void buildResolvedMaps() {
        MusicConfig cfg = MusicConfig.CONFIG;
        resolvedMenu = MusicPlayer.getTrack(cfg.menu);
        if (cfg.defaults != null) {
            for (Map.Entry<String, MusicConfig.MusicEntry> entry : cfg.defaults.entrySet()) {
                resolvedDefaults.put(entry.getKey(), MusicPlayer.resolveEntry(entry.getValue()));
            }
        }
        if (cfg.biome != null) {
            for (Map.Entry<String, Object> entry : cfg.biome.entrySet()) {
                resolvedBiomes.put(entry.getKey(), MusicPlayer.resolveEntry((MusicConfig.MusicEntry)entry.getValue()));
            }
        }
        if (cfg.boss != null) {
            for (Map.Entry<String, Object> entry : cfg.boss.entrySet()) {
                Music start = MusicPlayer.getTrack(((MusicConfig.BossMusic)entry.getValue()).start);
                Music loop = MusicPlayer.getTrack(((MusicConfig.BossMusic)entry.getValue()).loop);
                Music stop = MusicPlayer.getTrack(((MusicConfig.BossMusic)entry.getValue()).stop);
                resolvedBosses.put(entry.getKey(), new ResolvedBossMusic(start, loop, stop));
            }
        }
    }

    private static ResolvedEntry resolveEntry(MusicConfig.MusicEntry entry) {
        if (entry == null) {
            return null;
        }
        Music track = MusicPlayer.getTrack(entry.track);
        HashMap<String, Music> conds = null;
        if (entry.conditions != null) {
            conds = new HashMap<String, Music>();
            for (Map.Entry<String, String> c : entry.conditions.entrySet()) {
                conds.put(c.getKey(), MusicPlayer.getTrack(c.getValue()));
            }
        }
        return new ResolvedEntry(track, conds);
    }

    public static Music findMusic(MusicManager musicManager) {
        Music track = resolvedMenu;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            ResolvedEntry overworld = resolvedDefaults.get("minecraft:overworld");
            if (overworld != null && overworld.conditions != null) {
                track = overworld.conditions.get(MusicPlayer.getVariant((Level)player.m_9236_()).id);
            }
            String dimension = player.m_9236_().m_46472_().m_135782_().toString();
            String biomeName = player.m_9236_().m_204166_(player.m_20097_()).m_203543_().map(ResourceKey::m_135782_).orElse(ResourceLocation.fromNamespaceAndPath((String)"unknown", (String)"unknown")).toString();
            ResolvedEntry dimEntry = resolvedDefaults.get(dimension);
            if (dimEntry != null) {
                Music condTrack;
                if (dimEntry.track != null) {
                    track = dimEntry.track;
                } else if (dimEntry.conditions != null && (condTrack = dimEntry.conditions.get(MusicPlayer.getVariant((Level)player.m_9236_()).id)) != null) {
                    track = condTrack;
                }
            }
            for (String key : resolvedBiomes.keySet()) {
                Music condTrack;
                boolean found = false;
                if (key.startsWith("#") && player.m_9236_().m_204166_(player.m_20097_()).m_203656_(TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)ResourceLocation.parse((String)key.substring(1))))) {
                    found = true;
                } else if (biomeName.equals(key)) {
                    found = true;
                }
                if (!found) continue;
                ResolvedEntry biomeEntry = resolvedBiomes.get(key);
                if (biomeEntry.track != null) {
                    track = biomeEntry.track;
                    continue;
                }
                if (biomeEntry.conditions == null || (condTrack = biomeEntry.conditions.get(MusicPlayer.getVariant((Level)player.m_9236_()).id)) == null) continue;
                track = condTrack;
            }
        }
        if (track != null && CURRENT_TRACK != track) {
            if (CURRENT_TRACK != null && ((MusicManagerAccessor)musicManager).getCurrentMusic() != null) {
                musicManager.m_278151_(CURRENT_TRACK);
                isStopping = true;
            }
            CURRENT_TRACK = track;
        }
        return track;
    }

    private static Music getTrack(String str) {
        if (str == null) {
            return null;
        }
        ResourceLocation id = ResourceLocation.parse((String)str);
        Optional optional = ForgeRegistries.SOUND_EVENTS.getHolder(id);
        if (optional.isEmpty()) {
            ADJCore.LOGGER.error("Unknown sound event {}", (Object)str);
            return null;
        }
        Holder holder = (Holder)optional.get();
        return new Music(holder, 10, 20, false);
    }

    public static boolean shouldPlayMusic(MusicManager musicManager) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            String dimension = player.m_9236_().m_46472_().m_135782_().toString();
            double i = player.m_20186_();
            double j = player.m_20185_();
            double k = player.m_20189_();
            float f = 50.0f;
            AABB box = new AABB((double)((float)i - f), (double)((float)j - f), (double)((float)k - f), (double)((float)(i + 1.0) + f), (double)((float)(j + 1.0) + f), (double)((float)(k + 1.0) + f));
            for (LivingEntity e : player.m_9236_().m_142425_(EntityTypeTest.m_156916_(LivingEntity.class), box, ENTITY_PREDICATE)) {
                if (!MusicPlayer.getMonsterName(e).contains("entity.witherstormmod.witherstorm") && !MusicPlayer.getMonsterName(e).contains("entity.aquamirae.captain_cornelia") && !MusicPlayer.getMonsterName(e).contains("entity.unusualend.endstone_golem") && !dimension.equals("witherstormmod:bowels")) continue;
                return false;
            }
            return JukeboxTracker.noJukeboxesInRange();
        }
        return true;
    }

    private static String getMonsterName(LivingEntity e) {
        return e.m_7755_().toString().replace("translation{key='", "").replace("', args=[]}", "");
    }

    private static TrackVariant getVariant(Level level) {
        if (level.m_46470_()) {
            return TrackVariant.THUNDER;
        }
        if (level.m_46471_()) {
            return TrackVariant.RAIN;
        }
        long time = level.m_46468_();
        if (time % 24000L < 12550L) {
            return TrackVariant.DAY;
        }
        return TrackVariant.NIGHT;
    }

    static {
        resolvedDefaults = new HashMap<String, ResolvedEntry>();
        resolvedBiomes = new HashMap<String, ResolvedEntry>();
        resolvedBosses = new HashMap<String, ResolvedBossMusic>();
        WITHER_PREDICATE = entity -> true;
        ENTITY_PREDICATE = entity -> true;
        isStopping = false;
        CURRENT_TRACK = null;
        MusicPlayer.buildResolvedMaps();
    }

    public record ResolvedEntry(Music track, Map<String, Music> conditions) {
    }

    public record ResolvedBossMusic(Music start, Music loop, Music stop) {
    }

    private static enum TrackVariant {
        DAY("day"),
        NIGHT("night"),
        RAIN("rain"),
        THUNDER("thunder");

        public final String id;

        private TrackVariant(String text) {
            this.id = text;
        }
    }
}

