/*
 * Decompiled with CFR 0.152.
 */
package xyz.kohara.adjcore.client.music;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.SerializedName;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class MusicConfig {
    public static MusicConfig CONFIG;
    public String menu;
    @SerializedName(value="default")
    public Map<String, MusicEntry> defaults;
    public Map<String, MusicEntry> biome;
    public Map<String, BossMusic> boss;
    private static final DeferredRegister<SoundEvent> SOUNDS;

    public static void load(IEventBus bus) {
        Gson gson = new GsonBuilder().registerTypeAdapter(MusicEntry.class, (Object)new MusicEntryDeserializer()).create();
        try (BufferedReader reader = Files.newBufferedReader(Paths.get("config/adjcore/music.json", new String[0]));){
            CONFIG = (MusicConfig)gson.fromJson((Reader)reader, MusicConfig.class);
            HashSet toRegister = new HashSet();
            Consumer<String> addIfAdjMusic = str -> {
                if (str != null && str.startsWith("adj:music.")) {
                    toRegister.add(ResourceLocation.parse((String)str));
                }
            };
            addIfAdjMusic.accept(MusicConfig.CONFIG.menu);
            if (MusicConfig.CONFIG.defaults != null) {
                for (MusicEntry entry : MusicConfig.CONFIG.defaults.values()) {
                    if (entry == null) continue;
                    if (entry.track != null) {
                        addIfAdjMusic.accept(entry.track);
                    }
                    if (entry.conditions == null) continue;
                    entry.conditions.values().forEach(addIfAdjMusic);
                }
            }
            if (MusicConfig.CONFIG.biome != null) {
                for (MusicEntry entry : MusicConfig.CONFIG.biome.values()) {
                    if (entry == null) continue;
                    if (entry.track != null) {
                        addIfAdjMusic.accept(entry.track);
                    }
                    if (entry.conditions == null) continue;
                    entry.conditions.values().forEach(addIfAdjMusic);
                }
            }
            if (MusicConfig.CONFIG.boss != null) {
                for (BossMusic bossMusic : MusicConfig.CONFIG.boss.values()) {
                    if (bossMusic == null) continue;
                    addIfAdjMusic.accept(bossMusic.start);
                    addIfAdjMusic.accept(bossMusic.loop);
                    addIfAdjMusic.accept(bossMusic.stop);
                }
            }
            for (ResourceLocation soundId : toRegister) {
                if (ForgeRegistries.SOUND_EVENTS.containsKey(soundId)) continue;
                SOUNDS.register(soundId.m_135815_(), () -> SoundEvent.m_262824_((ResourceLocation)soundId));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            CONFIG = new MusicConfig();
        }
        SOUNDS.register(bus);
    }

    static {
        SOUNDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"adjcore".replace("core", ""));
    }

    public static class MusicEntry {
        public String track;
        public Map<String, String> conditions;
    }

    public static class MusicEntryDeserializer
    implements JsonDeserializer<MusicEntry> {
        public MusicEntry deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            MusicEntry entry = new MusicEntry();
            if (json.isJsonPrimitive()) {
                entry.track = json.getAsString();
            } else if (json.isJsonObject()) {
                entry.conditions = new HashMap<String, String>();
                JsonObject obj = json.getAsJsonObject();
                for (Map.Entry e : obj.entrySet()) {
                    entry.conditions.put((String)e.getKey(), ((JsonElement)e.getValue()).getAsString());
                }
            }
            return entry;
        }
    }

    public static class BossMusic {
        public String start;
        public String loop;
        public String stop;
    }
}

