/*
 * Decompiled with CFR 0.152.
 */
package xyz.kohara.adjcore.client.music;

import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import xyz.kohara.adjcore.client.music.MusicPlayer;

public class JukeboxTracker {
    public static Object2BooleanOpenHashMap<BlockPos> jukeboxes = new Object2BooleanOpenHashMap();

    public static void onJukeboxPlay(Level level, Minecraft minecraft, BlockPos pos) {
        if (level != null) {
            minecraft.m_91397_().m_278151_(MusicPlayer.CURRENT_TRACK);
            jukeboxes.put((Object)pos, true);
        }
    }

    public static void onJukeboxStop(BlockPos pos) {
        jukeboxes.removeBoolean((Object)pos);
    }

    public static boolean noJukeboxesInRange() {
        return jukeboxes.object2BooleanEntrySet().stream().noneMatch(Object2BooleanMap.Entry::getBooleanValue);
    }

    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(event -> {
            if (event.getLevel().m_5776_()) {
                jukeboxes.clear();
            }
        });
        MinecraftForge.EVENT_BUS.addListener(event -> {
            if (event.phase == TickEvent.Phase.END) {
                Minecraft mc = Minecraft.m_91087_();
                if (mc.f_91074_ != null && !jukeboxes.isEmpty()) {
                    for (Map.Entry entry : jukeboxes.entrySet()) {
                        BlockPos pos = (BlockPos)entry.getKey();
                        double distanceSq = mc.f_91074_.m_20275_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
                        if (distanceSq > 48.0) {
                            entry.setValue(false);
                            continue;
                        }
                        entry.setValue(true);
                        mc.m_91397_().m_278151_(MusicPlayer.CURRENT_TRACK);
                    }
                }
            }
        });
    }
}

