/*
 * Decompiled with CFR 0.152.
 */
package xyz.kohara.adjcore.client.handler;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.IItemDecorator;
import net.minecraftforge.client.event.RegisterItemDecorationsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="adjcore", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class PotionsDecorationHandler {
    private static final ChatFormatting[] POTION_AMPLIFIER_COLORS = new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.BLUE, ChatFormatting.DARK_BLUE, ChatFormatting.LIGHT_PURPLE, ChatFormatting.DARK_PURPLE, ChatFormatting.RED, ChatFormatting.WHITE};

    public static boolean renderPotionDecorations(GuiGraphics guiGraphics, ItemStack stack, int itemPosX, int itemPosY) {
        List mobEffects = PotionUtils.m_43547_((ItemStack)stack);
        if (mobEffects.isEmpty()) {
            return false;
        }
        int dotCount = mobEffects.stream().mapToInt(effect -> effect.m_19564_() + 1).sum();
        if (dotCount > 0) {
            int startX = itemPosX + 3;
            int startY = itemPosY + 13;
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 200.0f);
            guiGraphics.m_280509_(startX, startY, startX + 11, startY + 2, -16777216);
            for (int i = 0; i < Math.min(4, dotCount); ++i) {
                int colorIndex = Math.min((dotCount - i - 1) / 4, POTION_AMPLIFIER_COLORS.length - 1);
                Integer colorObj = POTION_AMPLIFIER_COLORS[colorIndex].m_126665_();
                int color = (colorObj != null ? colorObj : 0xFFFFFF) | 0xFF000000;
                guiGraphics.m_280509_(startX + 3 * i, startY, startX + 3 * i + 2, startY + 2, color | 0xFF000000);
            }
            guiGraphics.m_280168_().m_85849_();
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void onRegisterItemDecorator(RegisterItemDecorationsEvent event) {
        IItemDecorator decorator = (guiGraphics, font, stack, x, y) -> PotionsDecorationHandler.renderPotionDecorations(guiGraphics, stack, x, y);
        List<Item> potions = List.of(Items.f_42589_, Items.f_42739_, Items.f_42738_, Items.f_42736_);
        potions.forEach(potion -> event.register((ItemLike)potion, decorator));
    }
}

