/*
 * Decompiled with CFR 0.152.
 */
package xyz.kohara.adjcore.attributes;

import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="adjcore", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class AttributeReplace {
    private static final String CONFIG_FILE = "config/adjcore/attribute_replace.json";
    private static AttributeConfig REPLACEMENTS;

    public static void loadConfig() {
        File file = new File(CONFIG_FILE);
        try {
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
                try (FileWriter writer = new FileWriter(file);){
                    writer.write("{}");
                }
            }
            try (FileReader reader = new FileReader(file);){
                REPLACEMENTS = (AttributeConfig)new Gson().fromJson((Reader)reader, AttributeConfig.class);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load attribute replacement config", e);
        }
    }

    private static Attribute attributeFromString(String string) {
        String[] s = string.split(":");
        return (Attribute)ForgeRegistries.ATTRIBUTES.getValue(ResourceLocation.fromNamespaceAndPath((String)s[0], (String)s[1]));
    }

    private static ResourceLocation itemID(Item item) {
        return ForgeRegistries.ITEMS.getKey((Object)item);
    }

    private static String[] parseEntry(String entry) {
        return entry.split(";");
    }

    @SubscribeEvent
    public static void onItemAttributeModifier(ItemAttributeModifierEvent event) {
        Multimap originalModifiers = event.getModifiers();
        ArrayList replacementModifiers = new ArrayList();
        String itemKey = AttributeReplace.itemID(event.getItemStack().m_41720_()).toString();
        if (AttributeReplace.checkReplacementsNullability(true, false)) {
            return;
        }
        AttributeConfig.ItemConfig config = AttributeReplace.REPLACEMENTS.items.get(itemKey);
        if (originalModifiers.isEmpty() && config == null) {
            return;
        }
        for (Map.Entry entry : originalModifiers.entries()) {
            HashMap<Attribute, AttributeModifier> hashMap = new HashMap<Attribute, AttributeModifier>();
            hashMap.put((Attribute)entry.getKey(), (AttributeModifier)entry.getValue());
            replacementModifiers.add(hashMap);
        }
        if (config != null) {
            if (config.replace != null) {
                config.replace.forEach((configKey, configEntry) -> {
                    String[] key = AttributeReplace.parseEntry(configKey);
                    Attribute targetAttribute = AttributeReplace.attributeFromString(key[0]);
                    if (originalModifiers.keySet().contains(targetAttribute)) {
                        ListIterator iterator = replacementModifiers.listIterator();
                        while (iterator.hasNext()) {
                            Map map = (Map)iterator.next();
                            AttributeModifier modifier = (AttributeModifier)map.get(targetAttribute);
                            if (modifier == null || modifier.m_22217_().ordinal() != Integer.parseInt(key[1])) continue;
                            iterator.remove();
                            String[] configNew = AttributeReplace.parseEntry(configEntry);
                            AttributeModifier newModifier = new AttributeModifier(UUID.nameUUIDFromBytes((itemKey + key[0]).getBytes()), modifier.m_22214_(), modifier.m_22218_(), AttributeModifier.Operation.m_22236_((int)Integer.parseInt(configNew[1])));
                            Attribute newAttribute = AttributeReplace.attributeFromString(configNew[0]);
                            HashMap<Attribute, AttributeModifier> newMap = new HashMap<Attribute, AttributeModifier>();
                            newMap.put(newAttribute, newModifier);
                            iterator.add(newMap);
                        }
                    }
                });
            }
            if (config.remove != null) {
                config.remove.forEach(configEntry -> {
                    ListIterator iterator = replacementModifiers.listIterator();
                    Attribute targetAttribute = AttributeReplace.attributeFromString(configEntry);
                    while (iterator.hasNext()) {
                        Map map = (Map)iterator.next();
                        for (Attribute attr : map.keySet()) {
                            if (attr != targetAttribute) continue;
                            iterator.remove();
                        }
                    }
                });
            }
            if (config.add != null) {
                config.add.forEach(configEntry -> {
                    String[] entry;
                    EquipmentSlot slot = event.getSlotType();
                    if (slot == EquipmentSlot.m_20747_((String)(entry = AttributeReplace.parseEntry(configEntry))[3].toLowerCase())) {
                        UUID uuid = UUID.nameUUIDFromBytes((itemKey + entry[0]).getBytes());
                        if (entry.length == 5) {
                            switch (entry[4]) {
                                case "ATTACK_SPEED": {
                                    uuid = UUID.fromString("FA233E1C-4180-4865-B01B-BCCE9785ACA3");
                                    break;
                                }
                                case "ATTACK_DAMAGE": {
                                    uuid = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5C");
                                }
                            }
                        }
                        AttributeModifier newModifier = new AttributeModifier(uuid, "ADJ Tweaks", Double.parseDouble(entry[2]), AttributeModifier.Operation.m_22236_((int)Integer.parseInt(entry[1])));
                        Attribute newAttribute = AttributeReplace.attributeFromString(entry[0]);
                        HashMap<Attribute, AttributeModifier> newMap = new HashMap<Attribute, AttributeModifier>();
                        newMap.put(newAttribute, newModifier);
                        replacementModifiers.add(newMap);
                    }
                });
            }
        }
        if (!AttributeReplace.checkReplacementsNullability(false, true)) {
            AttributeReplace.REPLACEMENTS.global.forEach((configKey, configEntry) -> {
                String[] key = AttributeReplace.parseEntry(configKey);
                Attribute targetAttribute = AttributeReplace.attributeFromString(key[0]);
                ListIterator iterator = replacementModifiers.listIterator();
                while (iterator.hasNext()) {
                    Map map = (Map)iterator.next();
                    AttributeModifier modifier = (AttributeModifier)map.get(targetAttribute);
                    if (modifier == null || modifier.m_22217_().ordinal() != Integer.parseInt(key[1])) continue;
                    iterator.remove();
                    if (Objects.equals(configEntry, "remove")) continue;
                    String[] configNew = AttributeReplace.parseEntry(configEntry);
                    AttributeModifier newModifier = new AttributeModifier(UUID.nameUUIDFromBytes((itemKey + configNew[0]).getBytes()), modifier.m_22214_(), modifier.m_22218_(), AttributeModifier.Operation.m_22236_((int)Integer.parseInt(configNew[1])));
                    Attribute newAttribute = AttributeReplace.attributeFromString(configNew[0]);
                    HashMap<Attribute, AttributeModifier> newMap = new HashMap<Attribute, AttributeModifier>();
                    newMap.put(newAttribute, newModifier);
                    iterator.add(newMap);
                }
            });
        }
        ArrayList toRemove = new ArrayList(originalModifiers.entries());
        for (Map.Entry entry : toRemove) {
            event.removeModifier((Attribute)entry.getKey(), (AttributeModifier)entry.getValue());
        }
        for (Map map : replacementModifiers) {
            for (Map.Entry entry : map.entrySet()) {
                event.addModifier((Attribute)entry.getKey(), (AttributeModifier)entry.getValue());
            }
        }
    }

    private static boolean checkReplacementsNullability(boolean items, boolean global) {
        return REPLACEMENTS == null || items && AttributeReplace.REPLACEMENTS.items == null || global && AttributeReplace.REPLACEMENTS.global == null;
    }

    static {
        AttributeReplace.loadConfig();
    }

    public static class AttributeConfig {
        public Map<String, String> global;
        public Map<String, ItemConfig> items;

        public static class ItemConfig {
            public Map<String, String> replace;
            public List<String> add;
            public List<String> remove;
        }
    }
}

