/*
 * Decompiled with CFR 0.152.
 */
package xyz.kohara.adjcore;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Scanner;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xyz.kohara.adjcore.Config;
import xyz.kohara.adjcore.attributes.ModAttributes;
import xyz.kohara.adjcore.client.music.JukeboxTracker;
import xyz.kohara.adjcore.client.music.MusicConfig;
import xyz.kohara.adjcore.client.networking.ModMessages;
import xyz.kohara.adjcore.client.particle.ModParticles;
import xyz.kohara.adjcore.client.sounds.ModSoundEvents;
import xyz.kohara.adjcore.combat.DamageHandler;
import xyz.kohara.adjcore.combat.DamageIndicators;
import xyz.kohara.adjcore.curio.CurioControl;
import xyz.kohara.adjcore.effects.ModEffects;
import xyz.kohara.adjcore.effects.editor.EffectsEditor;
import xyz.kohara.adjcore.entity.WanderingTraderEdits;
import xyz.kohara.adjcore.misc.DelayedTaskScheduler;
import xyz.kohara.adjcore.misc.ModCapabilities;
import xyz.kohara.adjcore.misc.biomemodifiers.ModBiomeModifiers;
import xyz.kohara.adjcore.misc.capabilities.CapabilityEvents;
import xyz.kohara.adjcore.misc.credits.LoaderInfo;
import xyz.kohara.adjcore.misc.credits.ModCreditsBase;
import xyz.kohara.adjcore.misc.credits.ModInfo;
import xyz.kohara.adjcore.misc.placementmodifiertypes.ModPlacementModifierTypes;
import xyz.kohara.adjcore.potions.PotionsEditor;

@Mod(value="adjcore")
public class ADJCore {
    public static ModCreditsBase impl;
    public static final Logger LOGGER;
    public static final String MOD_ID = "adjcore";
    private static final String deathTextsFile = "config/adjcore/death_text.txt";
    private static final List<String> deathTexts;
    private static final String structuresIgnoreMinDistanceFile = "config/adjcore/structures_ignore_min_distance.txt";
    public static final List<String> structuresIgnoreMinDistance;
    private static final String potionNameOverridesFile = "config/adjcore/potion_name_overrides.txt";
    public static final Map<String, String> potionNameOverrides;

    public ADJCore() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC, "adjcore.toml");
        ModSoundEvents.registerSounds();
        IEventBus MOD_BUS = FMLJavaModLoadingContext.get().getModEventBus();
        MOD_BUS.addListener(this::commonSetup);
        MOD_BUS.addListener(this::clientSetup);
        MOD_BUS.addListener(this::addEntityAttributes);
        MOD_BUS.addListener(ModCapabilities::register);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new DamageHandler());
        MinecraftForge.EVENT_BUS.register(DelayedTaskScheduler.class);
        MinecraftForge.EVENT_BUS.register(WanderingTraderEdits.class);
        MinecraftForge.EVENT_BUS.register(CurioControl.class);
        MinecraftForge.EVENT_BUS.register(CapabilityEvents.class);
        MinecraftForge.EVENT_BUS.register((Object)new DamageIndicators());
        ModEffects.register(MOD_BUS);
        ModSoundEvents.SOUND_EVENTS.register(MOD_BUS);
        ModAttributes.register(MOD_BUS);
        MusicConfig.load(MOD_BUS);
        ModPlacementModifierTypes.register(MOD_BUS);
        ModParticles.register(MOD_BUS);
        JukeboxTracker.init();
        ModBiomeModifiers.register(MOD_BUS);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(ModMessages::register);
        PotionsEditor.edit();
        EffectsEditor.edit();
    }

    private void clientSetup(FMLClientSetupEvent event) {
    }

    private static ModCreditsBase initModCredits() {
        return new ModCreditsBase(){

            @Override
            public List<ModInfo> getMods() {
                ArrayList<ModInfo> mods = new ArrayList<ModInfo>();
                ModList.get().forEachModContainer((id, container) -> {
                    if (!(id.equals("minecraft") || id.equals("forge") || id.startsWith("generated_"))) {
                        String[] authors = new String[]{};
                        Optional modAuthors = container.getModInfo().getConfig().getConfigElement(new String[]{"authors"});
                        if (modAuthors.isPresent()) {
                            authors = modAuthors.get().toString().split("[,\\s]+");
                        }
                        mods.add(new ModInfo(container.getModInfo().getDisplayName(), List.of(authors), container.getModId()));
                    }
                });
                return mods;
            }

            @Override
            public LoaderInfo getLoaderInfo() {
                return new LoaderInfo("Forge Loader", "Forge", List.of("Forge Team"));
            }
        };
    }

    public static Component formatDeathMessage(Component deathMessage) {
        return Component.m_237119_().m_7220_((Component)Component.m_237113_((String)"s").m_130948_(Style.f_131099_.m_131150_(ResourceLocation.parse((String)"adjcore:icons")))).m_7220_((Component)Component.m_237113_((String)" ")).m_7220_((Component)deathMessage.m_6881_().m_130948_(Style.f_131099_.m_131148_(TextColor.m_131268_((String)"#FF1919"))));
    }

    @SubscribeEvent
    public void onServerChat(ServerChatEvent event) {
        event.setCanceled(true);
        Component message = event.getMessage();
        ServerPlayer player = event.getPlayer();
        MinecraftServer server = player.m_20194_();
        MutableComponent newMessage = Component.m_237119_().m_7220_((Component)Component.m_237113_((String)"c").m_130948_(Style.f_131099_.m_131150_(ResourceLocation.parse((String)"adjcore:icons")))).m_7220_((Component)Component.m_237113_((String)" [").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131268_((String)"#8A8A8A")))).m_7220_(player.m_7755_()).m_7220_((Component)Component.m_237113_((String)"] \u00bb ").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131268_((String)"#8A8A8A")))).m_7220_(message);
        server.m_6846_().m_11314_().forEach(arg_0 -> ADJCore.lambda$onServerChat$0((Component)newMessage, arg_0));
    }

    public void addEntityAttributes(EntityAttributeModificationEvent event) {
        for (EntityType type : event.getTypes()) {
            event.add(type, (Attribute)ModAttributes.DAMAGE_REDUCTION.get());
            event.add(type, (Attribute)ModAttributes.PROJECTILE_DAMAGE_REDUCTION.get());
        }
        event.add(EntityType.f_20532_, (Attribute)ModAttributes.MANA_COST_REDUCTION.get());
    }

    public static String getRandomDeathText() {
        Random rand = new Random();
        return "\"" + deathTexts.get(rand.nextInt(deathTexts.size())) + "\"";
    }

    public static String toSmallUnicode(String s) {
        String[] mappings;
        HashMap<Character, Character> map = new HashMap<Character, Character>();
        for (String pair : mappings = new String[]{"a\u1d00", "b\u0299", "c\u1d04", "d\u1d05", "e\u1d07", "f\ua730", "g\u0262", "h\u029c", "i\u026a", "j\u1d0a", "k\u1d0b", "l\u029f", "m\u1d0d", "n\u0274", "o\u1d0f", "p\u1d18", "r\u0280", "s\u0455", "t\u1d1b", "u\u1d1c", "w\u1d21", "x\u0445", "y\u028f", "z\u1d22"}) {
            map.put(Character.valueOf(pair.charAt(0)), Character.valueOf(pair.charAt(1)));
        }
        StringBuilder result = new StringBuilder();
        for (char c : s.toLowerCase().toCharArray()) {
            result.append(map.getOrDefault(Character.valueOf(c), Character.valueOf(c)));
        }
        return result.toString();
    }

    private static /* synthetic */ void lambda$onServerChat$0(Component newMessage, ServerPlayer serverPlayer) {
        if (serverPlayer.m_240422_()) {
            serverPlayer.m_213846_(newMessage);
        }
    }

    static {
        Scanner reader;
        impl = ADJCore.initModCredits();
        LOGGER = LogManager.getLogger();
        deathTexts = new ArrayList<String>();
        structuresIgnoreMinDistance = new ArrayList<String>();
        potionNameOverrides = new HashMap<String, String>();
        File config = new File(deathTextsFile);
        try {
            if (!config.exists()) {
                config.createNewFile();
            }
            reader = new Scanner(config);
            while (reader.hasNextLine()) {
                String deathMessage = reader.nextLine();
                deathTexts.add(deathMessage);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        config = new File(potionNameOverridesFile);
        try {
            if (!config.exists()) {
                config.createNewFile();
            }
            reader = new Scanner(config);
            while (reader.hasNext()) {
                String[] line = reader.nextLine().split(":");
                potionNameOverrides.put(line[0], line[1]);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        config = new File(structuresIgnoreMinDistanceFile);
        try {
            if (!config.exists()) {
                config.createNewFile();
            }
            reader = new Scanner(config);
            while (reader.hasNextLine()) {
                String structureID = reader.nextLine();
                structuresIgnoreMinDistance.add(structureID);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

