/*
 * Decompiled with CFR 0.152.
 */
package net.morimori0317.bestylewither.mixin;

import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.morimori0317.bestylewither.BEStyleWither;
import net.morimori0317.bestylewither.entity.BEWitherBoss;
import net.morimori0317.bestylewither.entity.goal.WitherChargeAttackGoal;
import net.morimori0317.bestylewither.mixin.AttributeSupplierBuilderAccessor;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={WitherBoss.class})
public abstract class WitherBossMixin
extends Monster
implements BEWitherBoss {
    @Unique
    private static final int MAX_WITHER_DEATH_TIME = 200;
    @Unique
    private int chargeTickCoolDown;
    @Unique
    private int clientChargeTick;
    @Unique
    private int clientChargeTickOld;
    @Unique
    private DamageSource lastDeathDamageSource;
    @Unique
    private boolean dropLootSkip;
    @Shadow
    @Final
    private float[] f_31424_;
    @Shadow
    private int f_31429_;
    @Shadow
    @Final
    private ServerBossEvent f_31430_;
    @Unique
    private static final EntityDataAccessor<Boolean> DATA_ID_FORCED_POWER = SynchedEntityData.m_135353_(WitherBoss.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    @Shadow
    public abstract int m_31502_();

    @Shadow
    public abstract boolean m_7090_();

    @Shadow
    protected abstract void m_31448_(int var1, double var2, double var4, double var6, boolean var8);

    @Inject(method={"createAttributes"}, at={@At(value="RETURN")})
    private static void createAttributes(CallbackInfoReturnable<AttributeSupplier.Builder> cir) {
        if (BEStyleWither.getConfig().isEnableDoubleHealth()) {
            Map<Attribute, AttributeInstance> preBuilder = ((AttributeSupplierBuilderAccessor)cir.getReturnValue()).getBuilder();
            AttributeInstance preMH = preBuilder.get(Attributes.f_22276_);
            double preVal = preMH != null ? preMH.m_22115_() : 300.0;
            ((AttributeSupplier.Builder)cir.getReturnValue()).m_22268_(Attributes.f_22276_, preVal * 2.0);
        }
    }

    public void m_5634_(float f) {
        if (this.m_31502_() > 0) {
            super.m_5634_(f * 2.0f);
        } else {
            super.m_5634_(f);
        }
    }

    protected WitherBossMixin(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"performRangedAttack(ILnet/minecraft/world/entity/LivingEntity;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void performRangedAttack(int i, LivingEntity livingEntity, CallbackInfo ci) {
        if (!BEStyleWither.getConfig().isEnableShootMoreBlueWitherSkull()) {
            return;
        }
        if (i == 0) {
            this.m_31448_(i, livingEntity.m_20185_(), livingEntity.m_20186_() + (double)livingEntity.m_20192_() * 0.5, livingEntity.m_20189_(), true);
            ci.cancel();
        }
    }

    @Inject(method={"isPowered"}, at={@At(value="RETURN")}, cancellable=true)
    private void isPowered(CallbackInfoReturnable<Boolean> cir) {
        if (BEStyleWither.getConfig().isEnableMaintainWeakenedState() && this.isForcedPowered() || BEStyleWither.getConfig().isEnableExplodeByDie() && this.f_20919_ > 0) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"registerGoals"}, at={@At(value="TAIL")})
    private void registerGoals(CallbackInfo ci) {
        this.f_21345_.m_25352_(1, (Goal)new WitherChargeAttackGoal((WitherBoss)this));
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void defineSynchedData(CallbackInfo ci) {
        this.f_19804_.m_135372_(DATA_ID_FORCED_POWER, (Object)false);
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void addAdditionalSaveData(CompoundTag compoundTag, CallbackInfo ci) {
        compoundTag.m_128379_("FPower", this.isForcedPowered());
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void readAdditionalSaveData(CompoundTag compoundTag, CallbackInfo ci) {
        this.setForcedPowered(compoundTag.m_128471_("FPower"));
    }

    @Inject(method={"aiStep"}, at={@At(value="HEAD")}, cancellable=true)
    private void aiStepPre(CallbackInfo ci) {
        if (BEStyleWither.getConfig().isEnableExplodeByDie() && this.m_21224_()) {
            ci.cancel();
        }
    }

    @Inject(method={"getDeathSound"}, at={@At(value="RETURN")}, cancellable=true)
    private void getDeathSound(CallbackInfoReturnable<SoundEvent> cir) {
        if (!BEStyleWither.getConfig().isEnableExplodeByDie()) {
            return;
        }
        if (this.f_20919_ <= 0) {
            cir.setReturnValue(null);
        }
    }

    public void m_8032_() {
        if (!BEStyleWither.getConfig().isEnableExplodeByDie()) {
            super.m_8032_();
            return;
        }
        if (this.m_6084_()) {
            super.m_8032_();
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (BEStyleWither.getConfig().isEnableExplodeByHalfHealth() && this.m_31502_() <= 0 && this.m_7090_() && !this.isForcedPowered()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, (double)-0.7f, 0.0));
        }
    }

    public void m_6667_(DamageSource damageSource) {
        if (!BEStyleWither.getConfig().isEnableExplodeByDie()) {
            super.m_6667_(damageSource);
            return;
        }
        this.dropLootSkip = true;
        super.m_6667_(damageSource);
        this.dropLootSkip = false;
        if (this.m_21224_()) {
            this.lastDeathDamageSource = damageSource;
        }
    }

    protected void m_6668_(DamageSource damageSource) {
        if (!this.dropLootSkip) {
            super.m_6668_(damageSource);
        }
    }

    @Inject(method={"aiStep"}, at={@At(value="TAIL")})
    private void aiStepPost(CallbackInfo ci) {
        int it;
        if (BEStyleWither.getConfig().isEnableSpinAndWhiteSummon() && (it = this.m_31502_()) > 0) {
            float par = 1.0f - (float)it / 220.0f;
            float angle = 60.0f * par + 5.0f;
            this.m_5618_(this.f_20883_ + angle);
            this.m_5616_(this.m_6080_() + angle);
            for (int i = 0; i < this.f_31424_.length; ++i) {
                this.f_31424_[i] = this.f_31424_[i] + angle;
            }
        }
        this.setChargeCoolDown(Math.max(0, this.getChargeCoolDown() - 1));
        if (this.m_9236_().m_5776_()) {
            this.clientChargeTickOld = this.clientChargeTick;
            this.clientChargeTick = Math.max(0, this.clientChargeTick - 1);
        }
    }

    @Inject(method={"customServerAiStep"}, at={@At(value="TAIL")})
    private void customServerAiStep(CallbackInfo ci) {
        if (this.m_31502_() <= 0 && this.m_7090_() && !this.isForcedPowered()) {
            if (BEStyleWither.getConfig().isEnableExplodeByHalfHealth()) {
                BlockHitResult clip = this.m_9236_().m_45547_(new ClipContext(this.m_20182_(), this.m_20182_().m_82520_(0.0, -30.0, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
                boolean flg = true;
                boolean exFlg = false;
                if (clip.m_6662_() != HitResult.Type.MISS) {
                    flg = Math.sqrt(clip.m_82448_((Entity)this)) <= 1.0 || this.m_20096_() || this.m_20069_() || this.m_5830_();
                    exFlg = true;
                }
                if (flg) {
                    this.setForcedPowered(true);
                    this.m_9236_().m_255391_((Entity)this, this.m_20185_(), this.m_20188_(), this.m_20189_(), 5.0f, false, Level.ExplosionInteraction.MOB);
                    if (!this.m_20067_()) {
                        this.m_9236_().m_6798_(1022, this.m_20183_(), 0);
                    }
                    if (exFlg && (this.m_9236_().m_46791_() == Difficulty.NORMAL || this.m_9236_().m_46791_() == Difficulty.HARD)) {
                        int wc = 3;
                        if (this.f_19796_.m_188503_(8) == 0) {
                            wc = 4;
                        }
                        for (int i = 0; i < wc; ++i) {
                            WitherSkeleton ws = new WitherSkeleton(EntityType.f_20497_, this.m_9236_());
                            ws.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), 0.0f);
                            ws.m_6518_((ServerLevelAccessor)this.m_9236_(), this.m_9236_().m_6436_(this.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                            this.m_9236_().m_7967_((Entity)ws);
                        }
                    }
                }
            } else {
                this.setForcedPowered(true);
            }
        }
    }

    private void setForcedPowered(boolean powered) {
        this.f_19804_.m_135381_(DATA_ID_FORCED_POWER, (Object)powered);
    }

    private boolean isForcedPowered() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ID_FORCED_POWER);
    }

    protected void m_6153_() {
        if (!BEStyleWither.getConfig().isEnableExplodeByDie()) {
            super.m_6153_();
            return;
        }
        ++this.f_20919_;
        this.f_31430_.m_142711_(this.m_21223_() / this.m_21233_());
        if (this.f_20919_ % 4 == 0) {
            this.setForcedPowered(this.f_19796_.m_188503_((int)Math.max(5.0f - (float)this.f_20919_ / 200.0f * 5.0f, 1.0f)) == 0);
        }
        if (!this.m_9236_().m_5776_()) {
            if (this.f_20919_ == 199) {
                SoundEvent soundevent;
                this.m_9236_().m_255391_((Entity)this, this.m_20185_(), this.m_20188_(), this.m_20189_(), 8.0f, false, Level.ExplosionInteraction.MOB);
                if (!this.m_20067_()) {
                    this.m_9236_().m_6798_(1022, this.m_20183_(), 0);
                }
                if ((soundevent = this.m_5592_()) != null) {
                    this.m_5496_(soundevent, this.m_6121_() * 1.5f, this.m_6100_());
                }
            } else if (this.f_20919_ >= 200 && !this.m_213877_()) {
                this.f_20889_ = Math.max(this.f_20889_, 1);
                DamageSource dmg = this.lastDeathDamageSource == null ? this.m_9236_().m_269111_().m_269341_() : this.lastDeathDamageSource;
                this.m_6668_(dmg);
                this.m_9236_().m_7605_((Entity)this, (byte)60);
                this.m_142687_(Entity.RemovalReason.KILLED);
            }
        }
    }

    @Override
    public int getWitherDeathTime() {
        return this.f_20919_;
    }

    @Override
    public float getWitherDeathTime(float delta) {
        return ((float)this.f_20919_ + delta - 1.0f) / 28.0f;
    }

    @Override
    public int getDestroyBlocksTick() {
        return this.f_31429_;
    }

    @Override
    public void setDestroyBlocksTick(int tick) {
        this.f_31429_ = tick;
    }

    @Override
    public int getChargeCoolDown() {
        return this.chargeTickCoolDown;
    }

    @Override
    public void setChargeCoolDown(int tick) {
        this.chargeTickCoolDown = tick;
    }

    @Override
    public void setClientCharge(int charge) {
        this.clientChargeTick = charge;
    }

    @Override
    public int getClientCharge() {
        return this.clientChargeTick;
    }

    @Override
    public float getClientCharge(float delta) {
        return Mth.m_14179_((float)delta, (float)this.clientChargeTickOld, (float)this.clientChargeTick);
    }
}

