/*
 * Decompiled with CFR 0.152.
 */
package net.morimori0317.bestylewither.entity.goal;

import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;
import net.morimori0317.bestylewither.BEStyleWither;
import net.morimori0317.bestylewither.entity.BEWitherBoss;
import net.morimori0317.bestylewither.explatform.BSWExpectPlatform;
import org.jetbrains.annotations.Nullable;

public class WitherChargeAttackGoal
extends Goal {
    public static final int chargeTime = 75;
    public static final int chargeHoldTime = 50;
    private final WitherBoss mob;
    @Nullable
    private LivingEntity target;
    private int chargeTick;
    private Vec3 lookAt;
    private float bodyRot;

    public WitherChargeAttackGoal(WitherBoss mob) {
        this.mob = mob;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.canUse(true);
    }

    public boolean canUse(boolean randed) {
        if (!BEStyleWither.getConfig().isEnableChargeAttack()) {
            return false;
        }
        if (randed && this.mob.m_217043_().m_188503_(75) != 0) {
            return false;
        }
        if (this.mob.m_31502_() > 0 || !this.mob.m_7090_() || ((BEWitherBoss)this.mob).getChargeCoolDown() > 0) {
            return false;
        }
        LivingEntity livingEntity = this.mob.m_5448_();
        if (livingEntity != null && livingEntity.m_6084_()) {
            this.target = livingEntity;
            return true;
        }
        return false;
    }

    public void m_8056_() {
        if (!this.mob.m_9236_().m_5776_()) {
            LevelChunk lch = (LevelChunk)this.mob.m_9236_().m_46865_(this.mob.m_20183_());
            BSWExpectPlatform.sendWhitherChargePacket(lch, this.mob.m_19879_());
        }
        this.chargeTick = this.m_183277_(75);
        this.mob.m_21573_().m_26573_();
    }

    public void m_8041_() {
        this.chargeTick = 0;
        this.target = null;
        ((BEWitherBoss)this.mob).setChargeCoolDown(200);
        this.lookAt = null;
        this.bodyRot = 0.0f;
    }

    public boolean m_8045_() {
        return this.canUse(false) && this.chargeTick > 0 && this.target != null;
    }

    public void m_8037_() {
        this.chargeTick = Math.max(0, this.chargeTick - 1);
        if (this.chargeTick > this.m_183277_(25)) {
            if (this.target != null) {
                this.mob.m_21563_().m_148051_((Entity)this.target);
                this.lookAt = this.mob.m_20154_();
                this.bodyRot = this.mob.f_20883_;
                this.mob.m_5618_(this.bodyRot);
                this.mob.m_20256_(Vec3.f_82478_);
            }
        } else {
            ((BEWitherBoss)this.mob).setDestroyBlocksTick(1);
            if (this.lookAt != null) {
                this.mob.m_21563_().m_24964_(this.lookAt);
                this.mob.m_20256_(this.lookAt.m_82490_(1.3));
                this.mob.m_5618_(this.bodyRot);
            }
        }
    }
}

