/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.sweetygarden;

import com.mojang.serialization.Codec;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mcreator.sweetygarden.DryBaileyaFeature;
import net.mcreator.sweetygarden.PassionFlowerTrunkFeature;
import net.mcreator.sweetygarden.SnowdropSpruceTreeFeature;
import net.mcreator.sweetygarden.init.SweetyGardenModBlocks;
import net.mcreator.sweetygarden.init.SweetyGardenModFeatures;
import net.mcreator.sweetygarden.init.SweetyGardenModItems;
import net.mcreator.sweetygarden.init.SweetyGardenModParticleTypes;
import net.mcreator.sweetygarden.init.SweetyGardenModTabs;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="sweety_garden")
public class SweetyGardenMod {
    public static final Logger LOGGER = LogManager.getLogger(SweetyGardenMod.class);
    public static final String MODID = "sweety_garden";
    public static final DeferredRegister<Feature<?>> FEATURE_REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"sweety_garden");
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> PASSION_FLOWER_TRUNK_FEATURE = FEATURE_REGISTRY.register("passion_flower_trunk", () -> new PassionFlowerTrunkFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> DRY_BAILEYA_FEATURE = FEATURE_REGISTRY.register("dry_baileya", () -> new DryBaileyaFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> SNOWDROP_SPRUCE_TREE_FEATURE = FEATURE_REGISTRY.register("snowdrop_spruce_tree", () -> new SnowdropSpruceTreeFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel PACKET_HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("sweety_garden", "sweety_garden"), () -> "1", "1"::equals, "1"::equals);
    private static int messageID = 0;
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();

    public SweetyGardenMod() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        SweetyGardenModBlocks.REGISTRY.register(bus);
        SweetyGardenModItems.REGISTRY.register(bus);
        SweetyGardenModTabs.REGISTRY.register(bus);
        SweetyGardenModFeatures.REGISTRY.register(bus);
        SweetyGardenModParticleTypes.REGISTRY.register(bus);
        FEATURE_REGISTRY.register(bus);
        bus.addListener(this::commonSetup);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(SweetyGardenModBlocks.HEATHER.getId(), SweetyGardenModBlocks.POTTED_HEATHER);
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(SweetyGardenModBlocks.EDELWEISS.getId(), SweetyGardenModBlocks.POTTED_EDELWEISS);
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(SweetyGardenModBlocks.PONTEDERIA.getId(), SweetyGardenModBlocks.POTTED_PONTEDERIA);
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(SweetyGardenModBlocks.SHAGGY_PURSLANE.getId(), SweetyGardenModBlocks.POTTED_SHAGGY_PURSLANE);
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(SweetyGardenModBlocks.BLOODY_DOGWOOD.getId(), SweetyGardenModBlocks.POTTED_BLOODY_DOGWOOD);
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(SweetyGardenModBlocks.BUSY_LIZZIE.getId(), SweetyGardenModBlocks.POTTED_BUSY_LIZZIE);
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(SweetyGardenModBlocks.SNOWDROP.getId(), SweetyGardenModBlocks.POTTED_SNOWDROP);
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(SweetyGardenModBlocks.BAILEYA.getId(), SweetyGardenModBlocks.POTTED_BAILEYA);
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(SweetyGardenModBlocks.CYAN_POPPY.getId(), SweetyGardenModBlocks.POTTED_CYAN_POPPY);
        });
    }

    public static <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        PACKET_HANDLER.registerMessage(messageID, messageType, encoder, decoder, messageConsumer);
        ++messageID;
    }

    public static void queueServerWork(int tick, Runnable action) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ArrayList actions = new ArrayList();
            workQueue.forEach(work -> {
                work.setValue((Integer)work.getValue() - 1);
                if ((Integer)work.getValue() == 0) {
                    actions.add(work);
                }
            });
            actions.forEach(e -> ((Runnable)e.getKey()).run());
            workQueue.removeAll(actions);
        }
    }
}

