/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.util;

import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.rasanovum.viaromana.core.SignCheck;
import net.rasanovum.viaromana.variables.VariableAccess;

public class PathUtils {
    public static ArrayList<Object> decodePathData(String input) {
        if (input == null || input.isEmpty()) {
            return new ArrayList<Object>();
        }
        String decodedData = "";
        ArrayList<Object> outputArrayList = new ArrayList<Object>();
        try {
            decodedData = new String(Base64.getDecoder().decode(input));
            String[] parts = decodedData.split("%");
            for (int i = 0; i < parts.length; ++i) {
                if (i <= 5) {
                    try {
                        outputArrayList.add(Double.parseDouble(parts[i]));
                    }
                    catch (NumberFormatException e) {
                        outputArrayList.add(parts[i]);
                    }
                    continue;
                }
                outputArrayList.add(parts[i]);
            }
        }
        catch (IllegalArgumentException e) {
            return new ArrayList<Object>();
        }
        if (outputArrayList.size() == 6) {
            outputArrayList.add("linkedSign");
        }
        return outputArrayList;
    }

    public static String encodePathData(LevelAccessor world, double x, double y, double z, Entity entity) {
        if (entity == null) {
            return "";
        }
        Object recordedData = "";
        String encodedData = "";
        recordedData = Math.floor(entity.m_20185_()) + 0.5 + "%" + entity.m_20186_() + "%" + (Math.floor(entity.m_20189_()) + 0.5) + "%" + x + "%" + y + "%" + z + "%" + SignCheck.getTarget(world, x, y, z, entity);
        encodedData = Base64.getEncoder().encodeToString(((String)recordedData).getBytes());
        return encodedData;
    }

    public static double calculateNodeDistance(Entity entity) {
        if (entity == null) {
            return 0.0;
        }
        double lastNodeDistance = 0.0;
        lastNodeDistance = Math.sqrt(Math.pow(entity.m_20185_() - VariableAccess.playerVariables.getLastNodeX(entity), 2.0) + Math.pow(entity.m_20189_() - VariableAccess.playerVariables.getLastNodeZ(entity), 2.0));
        return lastNodeDistance;
    }

    public static double calculatePathStartDistance(Entity entity) {
        if (entity == null) {
            return 0.0;
        }
        String pathStoredData = VariableAccess.playerVariables.getPathData(entity);
        ArrayList<Object> pathStoredArrayList = PathUtils.decodePathData(pathStoredData);
        if (pathStoredArrayList.isEmpty() || pathStoredArrayList.size() < 3) {
            return 0.0;
        }
        double startX = 0.0;
        double startZ = 0.0;
        try {
            if (pathStoredArrayList.get(0) instanceof Double) {
                startX = (Double)pathStoredArrayList.get(0);
            }
            if (pathStoredArrayList.get(2) instanceof Double) {
                startZ = (Double)pathStoredArrayList.get(2);
            }
        }
        catch (Exception e) {
            return 0.0;
        }
        return Math.sqrt(Math.pow(startX - entity.m_20185_(), 2.0) + Math.pow(startZ - entity.m_20189_(), 2.0));
    }

    public static boolean isBlockValidPath(LevelAccessor world, double x, double y, double z) {
        BlockState targetBlock = Blocks.f_50016_.m_49966_();
        if (world.m_46859_(BlockPos.m_274561_((double)x, (double)y, (double)z))) {
            return false;
        }
        targetBlock = world.m_8055_(BlockPos.m_274561_((double)x, (double)y, (double)z));
        List<Object> validTagList = VariableAccess.mapVariables.getValidTagList();
        for (int index0 = 0; index0 < validTagList.size(); ++index0) {
            String s;
            String tagString;
            Object object = validTagList.get(index0);
            String string = tagString = object instanceof String ? (s = (String)object) : "";
            if (!targetBlock.m_204336_(TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation(tagString.toLowerCase(Locale.ENGLISH))))) continue;
            return true;
        }
        List<Object> validBlockList = VariableAccess.mapVariables.getValidBlockList(world);
        for (int index1 = 0; index1 < validBlockList.size(); ++index1) {
            String s;
            String blockString;
            Object object = validBlockList.get(index1);
            String string = blockString = object instanceof String ? (s = (String)object) : "";
            if (!BuiltInRegistries.f_256975_.m_7981_((Object)targetBlock.m_60734_()).toString().equals(blockString)) continue;
            return true;
        }
        List<Object> validStringList = VariableAccess.mapVariables.getValidStringList(world);
        for (int index2 = 0; index2 < validStringList.size(); ++index2) {
            String s;
            String validString;
            Object object = validStringList.get(index2);
            String string = validString = object instanceof String ? (s = (String)object) : "";
            if (validString.isEmpty() || !BuiltInRegistries.f_256975_.m_7981_((Object)targetBlock.m_60734_()).toString().contains(validString)) continue;
            return true;
        }
        return false;
    }

    public static double calculateInfrastructureQuality(LevelAccessor world, Entity entity) {
        double checkRadius;
        if (entity == null) {
            return 0.0;
        }
        double surfaceLevel = 0.0;
        double sx = 0.0;
        double sz = 0.0;
        double pathQuality = 0.0;
        double loopAmount = 0.0;
        double sy = 0.0;
        double checkX = 0.0;
        double checkY = 0.0;
        double checkZ = 0.0;
        surfaceLevel = entity.m_20186_();
        if (!entity.m_20096_()) {
            while (world.m_46859_(BlockPos.m_274561_((double)entity.m_20185_(), (double)surfaceLevel, (double)entity.m_20189_()))) {
                surfaceLevel -= 1.0;
                if (!(entity.m_20186_() - surfaceLevel >= 10.0)) continue;
                return 0.0;
            }
        }
        if ((checkRadius = VariableAccess.mapVariables.getInfrastructureCheckRadius(world)) % 2.0 == 0.0) {
            VariableAccess.mapVariables.setInfrastructureCheckRadius(world, checkRadius += 1.0);
            VariableAccess.mapVariables.markAndSync(world);
        }
        loopAmount = checkRadius * 2.0 + 1.0;
        sx = 0.0 - checkRadius;
        for (int index1 = 0; index1 < (int)loopAmount; ++index1) {
            sy = 0.0 - checkRadius;
            for (int index2 = 0; index2 < (int)loopAmount; ++index2) {
                sz = 0.0 - checkRadius;
                for (int index3 = 0; index3 < (int)loopAmount; ++index3) {
                    checkX = Math.floor(entity.m_20185_() + sx);
                    if (PathUtils.isBlockValidPath(world, checkX, checkY = Math.ceil(surfaceLevel) - 1.0 + sy, checkZ = Math.floor(entity.m_20189_() + sz))) {
                        pathQuality += 1.0;
                    }
                    sz += 1.0;
                }
                sy += 1.0;
            }
            sx += 1.0;
        }
        return pathQuality / Math.pow(checkRadius * 2.0 + 1.0, 2.0);
    }
}

