/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.network;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.LevelResource;
import net.rasanovum.viaromana.PlatformUtils;
import net.rasanovum.viaromana.network.NetworkHandler;

public class ViaRomanaModVariables {
    public static List<Object> ValidTagList = new ArrayList<Object>();
    public static NetworkHandler networkHandler = null;
    private static final Map<UUID, PlayerVariables> playerVariables = new ConcurrentHashMap<UUID, PlayerVariables>();
    private static PlayerVariables clientPlayerVariables = new PlayerVariables();

    private static ListTag saveArrayList(List<?> list) {
        ListTag listTag = new ListTag();
        for (Object e : list) {
            CompoundTag tag = new CompoundTag();
            if (e instanceof String) {
                tag.m_128359_("value", (String)e);
            } else if (e instanceof Number) {
                tag.m_128347_("value", ((Number)e).doubleValue());
            } else if (e instanceof Boolean) {
                tag.m_128379_("value", ((Boolean)e).booleanValue());
            } else if (e instanceof List) {
                tag.m_128365_("value", (Tag)ViaRomanaModVariables.saveArrayList((List)e));
            }
            listTag.add((Object)tag);
        }
        return listTag;
    }

    private static List<Object> loadArrayList(ListTag listTag) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Tag e : listTag) {
            if (!(e instanceof CompoundTag)) continue;
            CompoundTag tag = (CompoundTag)e;
            Tag value = tag.m_128423_("value");
            if (value instanceof StringTag) {
                list.add(tag.m_128461_("value"));
                continue;
            }
            if (value instanceof NumericTag) {
                list.add(tag.m_128459_("value"));
                continue;
            }
            if (value instanceof ByteTag) {
                list.add(tag.m_128471_("value"));
                continue;
            }
            if (!(value instanceof ListTag)) continue;
            list.add(ViaRomanaModVariables.loadArrayList((ListTag)value));
        }
        return list;
    }

    public static PlayerVariables getPlayerVariables(Entity entity) {
        if (entity == null) {
            PlatformUtils.getLogger().warn("Attempted to get PlayerVariables for null entity.");
            return new PlayerVariables();
        }
        if (entity.m_9236_().m_5776_()) {
            return clientPlayerVariables;
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            UUID playerId = player.m_20148_();
            return playerVariables.computeIfAbsent(playerId, id -> {
                PlayerVariables vars = new PlayerVariables();
                CompoundTag playerData = ViaRomanaModVariables.loadNBTFromFile(player.m_20194_(), id.toString());
                if (playerData != null) {
                    vars.readNBT(playerData);
                    PlatformUtils.getLogger().debug("Loaded PlayerVariables from file for {}", (Object)player.m_7755_().getString());
                } else {
                    PlatformUtils.getLogger().debug("No existing PlayerVariables file found for {}, creating new.", (Object)player.m_7755_().getString());
                }
                return vars;
            });
        }
        PlatformUtils.getLogger().warn("Tried to get PlayerVariables for non-ServerPlayer entity: {}", (Object)entity.m_6095_().m_20675_());
        return new PlayerVariables();
    }

    public static void playerLoggedOut(ServerPlayer player) {
        UUID playerId;
        PlayerVariables vars;
        if (player != null && (vars = playerVariables.get(playerId = player.m_20148_())) != null) {
            ViaRomanaModVariables.savePlayerVariablesToFile(player.m_20194_(), playerId.toString(), vars);
            playerVariables.remove(playerId);
            PlatformUtils.getLogger().debug("Saved and unloaded PlayerVariables for {}", (Object)player.m_7755_().getString());
        }
    }

    public static PlayerVariables playerLoggedIn(ServerPlayer player) {
        if (player == null) {
            return new PlayerVariables();
        }
        PlayerVariables vars = ViaRomanaModVariables.getPlayerVariables((Entity)player);
        vars.syncToClient(player);
        MapVariables.get((LevelAccessor)player.m_9236_()).syncToPlayer(player);
        WorldVariables.get((LevelAccessor)player.m_9236_()).syncToPlayer(player);
        return vars;
    }

    public static void playerRespawned(ServerPlayer oldPlayer, ServerPlayer newPlayer, boolean keepAllPlayerData) {
        if (oldPlayer == null || newPlayer == null) {
            return;
        }
        PlayerVariables oldVars = playerVariables.get(oldPlayer.m_20148_());
        PlayerVariables newVars = ViaRomanaModVariables.getPlayerVariables((Entity)newPlayer);
        if (oldVars != null) {
            if (keepAllPlayerData) {
                newVars.readNBT(oldVars.writeNBT());
                PlatformUtils.getLogger().debug("Copied all PlayerVariables on respawn for {}", (Object)newPlayer.m_7755_().getString());
            } else {
                PlatformUtils.getLogger().debug("Did not copy PlayerVariables on respawn (keepAllPlayerData=false) for {}", (Object)newPlayer.m_7755_().getString());
            }
            newVars.syncToClient(newPlayer);
        } else {
            PlatformUtils.getLogger().warn("Could not find old PlayerVariables for {} during respawn.", (Object)oldPlayer.m_7755_().getString());
            newVars.syncToClient(newPlayer);
        }
    }

    public static void savePlayerVariablesToFile(MinecraftServer server, String playerUUID, PlayerVariables data) {
        if (server == null || data == null) {
            return;
        }
        ViaRomanaModVariables.saveNBTToFile(server, playerUUID, data.writeNBT());
    }

    public static void loadPlayerVariablesFromFile(ServerPlayer player) {
        if (player != null && player.m_20194_() != null) {
            UUID playerId = player.m_20148_();
            CompoundTag playerData = ViaRomanaModVariables.loadNBTFromFile(player.m_20194_(), playerId.toString());
            if (playerData != null) {
                PlayerVariables playerVar = playerVariables.computeIfAbsent(playerId, id -> new PlayerVariables());
                playerVar.readNBT(playerData);
                PlatformUtils.getLogger().debug("Force-loaded PlayerVariables from file for {}", (Object)player.m_7755_().getString());
                playerVar.syncToClient(player);
            }
        }
    }

    private static File getPlayerDataDirectory(MinecraftServer server) {
        return new File(server.m_129843_(LevelResource.f_78176_).toFile(), PlatformUtils.getModId());
    }

    private static void saveNBTToFile(MinecraftServer server, String fileName, CompoundTag nbt) {
        if (server == null) {
            return;
        }
        try {
            File dataDir = ViaRomanaModVariables.getPlayerDataDirectory(server);
            if (!dataDir.exists()) {
                if (!dataDir.mkdirs()) {
                    PlatformUtils.getLogger().error("Could not create player data directory: {}", (Object)dataDir.getAbsolutePath());
                    return;
                }
                PlatformUtils.getLogger().debug("Created player data directory: {}", (Object)dataDir.getAbsolutePath());
            }
            File file = new File(dataDir, fileName + ".dat");
            File backupFile = new File(dataDir, fileName + ".dat_old");
            if (file.exists()) {
                if (backupFile.exists()) {
                    backupFile.delete();
                }
                file.renameTo(backupFile);
            }
            NbtIo.m_128944_((CompoundTag)nbt, (File)file);
        }
        catch (IOException e) {
            PlatformUtils.getLogger().error("Failed to save player variables NBT for " + fileName, (Throwable)e);
        }
    }

    private static CompoundTag loadNBTFromFile(MinecraftServer server, String fileName) {
        if (server == null) {
            return null;
        }
        File dataDir = ViaRomanaModVariables.getPlayerDataDirectory(server);
        File file = new File(dataDir, fileName + ".dat");
        File backupFile = new File(dataDir, fileName + ".dat_old");
        if (file.exists()) {
            try {
                return NbtIo.m_128937_((File)file);
            }
            catch (IOException e) {
                PlatformUtils.getLogger().error("Failed to load player variables NBT from " + file.getName() + ", trying backup.", (Throwable)e);
                if (backupFile.exists()) {
                    try {
                        PlatformUtils.getLogger().warn("Attempting to load from backup file: {}", (Object)backupFile.getName());
                        return NbtIo.m_128937_((File)backupFile);
                    }
                    catch (IOException e2) {
                        PlatformUtils.getLogger().error("Failed to load player variables NBT from backup " + backupFile.getName() + " as well.", (Throwable)e2);
                    }
                }
            }
        } else if (backupFile.exists()) {
            try {
                PlatformUtils.getLogger().warn("Main file {} missing, attempting to load from backup file: {}", (Object)file.getName(), (Object)backupFile.getName());
                return NbtIo.m_128937_((File)backupFile);
            }
            catch (IOException e) {
                PlatformUtils.getLogger().error("Failed to load player variables NBT from backup " + backupFile.getName(), (Throwable)e);
            }
        }
        return null;
    }

    public static class PlayerVariables {
        public boolean ChartingPath = false;
        public double FadeAmount = 0.0;
        public boolean FadeIncrease = false;
        public String lastMessage = "";
        public double LastNodeX = 0.0;
        public double LastNodeY = 0.0;
        public double LastNodeZ = 0.0;
        public String LastSignPosition = "";
        public double LeftClickTimer = 0.0;
        public double MessageCooldown = 0.0;
        public String PathData = "";
        public boolean ReceivedTutorial = false;
        public double TitleCooldown = 0.0;
        public String TitleString = "";
        public double ToastTimer = 0.0;
        public boolean AwaitingToast = false;

        public CompoundTag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128379_("ChartingPath", this.ChartingPath);
            nbt.m_128347_("FadeAmount", this.FadeAmount);
            nbt.m_128379_("FadeIncrease", this.FadeIncrease);
            nbt.m_128359_("lastMessage", this.lastMessage);
            nbt.m_128347_("LastNodeX", this.LastNodeX);
            nbt.m_128347_("LastNodeY", this.LastNodeY);
            nbt.m_128347_("LastNodeZ", this.LastNodeZ);
            nbt.m_128359_("LastSignPosition", this.LastSignPosition);
            nbt.m_128347_("LeftClickTimer", this.LeftClickTimer);
            nbt.m_128347_("MessageCooldown", this.MessageCooldown);
            nbt.m_128359_("PathData", this.PathData);
            nbt.m_128379_("ReceivedTutorial", this.ReceivedTutorial);
            nbt.m_128347_("TitleCooldown", this.TitleCooldown);
            nbt.m_128359_("TitleString", this.TitleString);
            nbt.m_128347_("ToastTimer", this.ToastTimer);
            nbt.m_128379_("AwaitingToast", this.AwaitingToast);
            return nbt;
        }

        public void readNBT(CompoundTag nbt) {
            this.ChartingPath = nbt.m_128471_("ChartingPath");
            this.FadeAmount = nbt.m_128459_("FadeAmount");
            this.FadeIncrease = nbt.m_128471_("FadeIncrease");
            this.lastMessage = nbt.m_128461_("lastMessage");
            this.LastNodeX = nbt.m_128459_("LastNodeX");
            this.LastNodeY = nbt.m_128459_("LastNodeY");
            this.LastNodeZ = nbt.m_128459_("LastNodeZ");
            this.LastSignPosition = nbt.m_128461_("LastSignPosition");
            this.LeftClickTimer = nbt.m_128459_("LeftClickTimer");
            this.MessageCooldown = nbt.m_128459_("MessageCooldown");
            this.PathData = nbt.m_128461_("PathData");
            this.ReceivedTutorial = nbt.m_128471_("ReceivedTutorial");
            this.TitleCooldown = nbt.m_128459_("TitleCooldown");
            this.TitleString = nbt.m_128461_("TitleString");
            this.ToastTimer = nbt.m_128459_("ToastTimer");
            this.AwaitingToast = nbt.m_128471_("AwaitingToast");
        }

        public void syncToClient(ServerPlayer player) {
            if (player == null) {
                return;
            }
            if (networkHandler != null) {
                networkHandler.sendToPlayer(player, new PlayerVariablesSyncMessage(this));
            } else {
                PlatformUtils.getLogger().warn("Network handler not initialized, cannot sync PlayerVariables for {}.", (Object)player.m_7755_().getString());
            }
        }
    }

    public static class MapVariables
    extends SavedData {
        private static final String DATA_NAME = "via_romana_mapvars";
        public static MapVariables clientSide = new MapVariables();
        private boolean dirty = false;
        public String AcceptedBlockIDs = "\"\"";
        public String AcceptedBlockStrings = "\"\"";
        public String AcceptedBlockTags = "\"\"";
        public String AcceptedDimensions = "\"\"";
        public String AcceptedEntities = "\"\"";
        public double InfrastructureCheckQuality = 0.6;
        public double InfrastructureCheckRadius = 1.0;
        public double NodeDistanceMaximum = 20.0;
        public double NodeDistanceMinimum = 10.0;
        public double PathDistanceMaximum = 100000.0;
        public double PathDistanceMinimum = 50.0;
        public double TravelFatigueCooldown = 30.0;
        public List<Object> ValidBlockList = new ArrayList<Object>();
        public List<Object> ValidStringList = new ArrayList<Object>();
        public List<Object> ValidEntityList = new ArrayList<Object>();
        public List<Object> ValidDimensionList = new ArrayList<Object>();
        public List<Object> ValidSignList = new ArrayList<Object>();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.AcceptedBlockIDs = nbt.m_128461_("AcceptedBlockIDs");
            this.AcceptedBlockStrings = nbt.m_128461_("AcceptedBlockStrings");
            this.AcceptedBlockTags = nbt.m_128461_("AcceptedBlockTags");
            this.AcceptedDimensions = nbt.m_128461_("AcceptedDimensions");
            this.AcceptedEntities = nbt.m_128461_("AcceptedEntities");
            this.InfrastructureCheckQuality = nbt.m_128459_("InfrastructureCheckQuality");
            this.InfrastructureCheckRadius = nbt.m_128459_("InfrastructureCheckRadius");
            this.NodeDistanceMaximum = nbt.m_128459_("NodeDistanceMaximum");
            this.NodeDistanceMinimum = nbt.m_128459_("NodeDistanceMinimum");
            this.PathDistanceMaximum = nbt.m_128459_("PathDistanceMaximum");
            this.PathDistanceMinimum = nbt.m_128459_("PathDistanceMinimum");
            this.TravelFatigueCooldown = nbt.m_128459_("TravelFatigueCooldown");
            this.ValidBlockList = nbt.m_128425_("ValidBlockList", 9) ? ViaRomanaModVariables.loadArrayList(nbt.m_128437_("ValidBlockList", 10)) : new ArrayList<Object>();
            this.ValidStringList = nbt.m_128425_("ValidStringList", 9) ? ViaRomanaModVariables.loadArrayList(nbt.m_128437_("ValidStringList", 10)) : new ArrayList<Object>();
            this.ValidEntityList = nbt.m_128425_("ValidEntityList", 9) ? ViaRomanaModVariables.loadArrayList(nbt.m_128437_("ValidEntityList", 10)) : new ArrayList<Object>();
            this.ValidDimensionList = nbt.m_128425_("ValidDimensionList", 9) ? ViaRomanaModVariables.loadArrayList(nbt.m_128437_("ValidDimensionList", 10)) : new ArrayList<Object>();
            this.ValidSignList = nbt.m_128425_("ValidSignList", 9) ? ViaRomanaModVariables.loadArrayList(nbt.m_128437_("ValidSignList", 10)) : new ArrayList<Object>();
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128359_("AcceptedBlockIDs", this.AcceptedBlockIDs);
            nbt.m_128359_("AcceptedBlockStrings", this.AcceptedBlockStrings);
            nbt.m_128359_("AcceptedBlockTags", this.AcceptedBlockTags);
            nbt.m_128359_("AcceptedDimensions", this.AcceptedDimensions);
            nbt.m_128359_("AcceptedEntities", this.AcceptedEntities);
            nbt.m_128347_("InfrastructureCheckQuality", this.InfrastructureCheckQuality);
            nbt.m_128347_("InfrastructureCheckRadius", this.InfrastructureCheckRadius);
            nbt.m_128347_("NodeDistanceMaximum", this.NodeDistanceMaximum);
            nbt.m_128347_("NodeDistanceMinimum", this.NodeDistanceMinimum);
            nbt.m_128347_("PathDistanceMaximum", this.PathDistanceMaximum);
            nbt.m_128347_("PathDistanceMinimum", this.PathDistanceMinimum);
            nbt.m_128347_("TravelFatigueCooldown", this.TravelFatigueCooldown);
            nbt.m_128365_("ValidBlockList", (Tag)ViaRomanaModVariables.saveArrayList(this.ValidBlockList));
            nbt.m_128365_("ValidStringList", (Tag)ViaRomanaModVariables.saveArrayList(this.ValidStringList));
            nbt.m_128365_("ValidEntityList", (Tag)ViaRomanaModVariables.saveArrayList(this.ValidEntityList));
            nbt.m_128365_("ValidDimensionList", (Tag)ViaRomanaModVariables.saveArrayList(this.ValidDimensionList));
            nbt.m_128365_("ValidSignList", (Tag)ViaRomanaModVariables.saveArrayList(this.ValidSignList));
            return nbt;
        }

        public void m_77762_() {
            super.m_77762_();
            this.dirty = true;
        }

        public void markClean() {
            this.dirty = false;
        }

        public boolean m_77764_() {
            return this.dirty;
        }

        public static MapVariables get(LevelAccessor world) {
            if (world == null) {
                PlatformUtils.getLogger().warn("Attempted to get MapVariables with null world, returning clientSide instance.");
                return clientSide;
            }
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                MinecraftServer server = level.m_7654_();
                ServerLevel overworld = server.m_129880_(Level.f_46428_);
                if (overworld == null) {
                    PlatformUtils.getLogger().error("Could not get Overworld from server to load MapVariables!");
                    return clientSide;
                }
                return (MapVariables)overworld.m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }

        public void syncToPlayer(ServerPlayer player) {
            if (networkHandler != null) {
                networkHandler.sendToPlayer(player, new SavedDataSyncMessage(0, this));
            } else {
                PlatformUtils.getLogger().warn("Network handler not initialized, cannot sync MapVariables.");
            }
            this.markClean();
        }
    }

    public static class WorldVariables
    extends SavedData {
        private static final String DATA_NAME = "via_romana_worldvars";
        public static WorldVariables clientSide = new WorldVariables();
        private boolean dirty = false;

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void m_77762_() {
            super.m_77762_();
            this.dirty = true;
        }

        public void markClean() {
            this.dirty = false;
        }

        public boolean m_77764_() {
            return this.dirty;
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }

        public void syncToPlayer(ServerPlayer player) {
            if (networkHandler != null) {
                networkHandler.sendToPlayer(player, new SavedDataSyncMessage(1, this));
            } else {
                PlatformUtils.getLogger().warn("Network handler not initialized, cannot sync WorldVariables.");
            }
            this.markClean();
        }
    }

    public static class PlayerVariablesSyncMessage {
        public final CompoundTag dataTag;

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.dataTag = data.writeNBT();
        }

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.dataTag = buffer.m_130260_();
        }

        public void write(FriendlyByteBuf buffer) {
            buffer.m_130079_(this.dataTag);
        }

        public static void handleClient(PlayerVariablesSyncMessage message) {
            clientPlayerVariables.readNBT(message.dataTag);
            PlatformUtils.getLogger().debug("Client received and processed PlayerVariables sync.");
        }

        public static void handleServer(PlayerVariablesSyncMessage message, ServerPlayer player) {
            if (player != null) {
                PlayerVariables variables = ViaRomanaModVariables.getPlayerVariables((Entity)player);
                variables.readNBT(message.dataTag);
                PlatformUtils.getLogger().debug("Server received and processed PlayerVariables sync from {}", (Object)player.m_7755_().getString());
            }
        }
    }

    public static class SavedDataSyncMessage {
        public final int type;
        public final CompoundTag dataTag;

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.dataTag = data.m_7176_(new CompoundTag());
        }

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            this.dataTag = buffer.m_130260_();
        }

        public void write(FriendlyByteBuf buffer) {
            buffer.writeInt(this.type);
            buffer.m_130079_(this.dataTag);
        }

        public static void handleClient(SavedDataSyncMessage message) {
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft.f_91073_ == null) {
                PlatformUtils.getLogger().warn("Received SavedDataSyncMessage on client with null level.");
                return;
            }
            if (message.type == 0) {
                MapVariables.clientSide.read(message.dataTag);
                PlatformUtils.getLogger().debug("Client received and processed MapVariables sync.");
            } else if (message.type == 1) {
                WorldVariables.clientSide.read(message.dataTag);
                PlatformUtils.getLogger().debug("Client received and processed WorldVariables sync.");
            }
        }
    }
}

