/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.forge.util;

import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.util.LazyOptional;
import net.rasanovum.viaromana.forge.capabilities.CustomDataCapability;

public class BlockTagHelper {
    public static void setDouble(LevelAccessor world, BlockPos pos, String tagName, double tagValue) {
        BlockTagHelper.updateBlockEntity(world, pos, customData -> customData.m_128347_(tagName, tagValue));
    }

    public static void setString(LevelAccessor world, BlockPos pos, String tagName, String tagValue) {
        BlockTagHelper.updateBlockEntity(world, pos, customData -> customData.m_128359_(tagName, tagValue));
    }

    public static void setBoolean(LevelAccessor world, BlockPos pos, String tagName, boolean tagValue) {
        BlockTagHelper.updateBlockEntity(world, pos, customData -> customData.m_128379_(tagName, tagValue));
    }

    public static double getDouble(LevelAccessor world, BlockPos pos, String tagName) {
        return BlockTagHelper.getValueFromBlockEntity(world, pos, customData -> customData.m_128459_(tagName), 0.0);
    }

    public static String getString(LevelAccessor world, BlockPos pos, String tagName) {
        return BlockTagHelper.getValueFromBlockEntity(world, pos, customData -> customData.m_128461_(tagName), "");
    }

    public static boolean getBoolean(LevelAccessor world, BlockPos pos, String tagName) {
        return BlockTagHelper.getValueFromBlockEntity(world, pos, customData -> customData.m_128471_(tagName), false);
    }

    private static void updateBlockEntity(LevelAccessor world, BlockPos pos, Consumer<CompoundTag> updateFunction) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity != null) {
            LazyOptional capability = blockEntity.getCapability(CustomDataCapability.CUSTOM_DATA_CAPABILITY);
            capability.ifPresent(dataHolder -> {
                CompoundTag customData = dataHolder.getCustomData();
                updateFunction.accept(customData);
                dataHolder.setCustomData(customData);
                blockEntity.m_6596_();
                BlockState state = world.m_8055_(pos);
                world.m_7731_(pos, state, 3);
                if (world instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)world;
                    serverWorld.m_7726_().m_8450_(pos);
                    LevelChunk chunk = serverWorld.m_7726_().m_62227_(pos.m_123341_() >> 4, pos.m_123343_() >> 4, true);
                    if (chunk != null) {
                        chunk.m_8092_(true);
                    }
                }
            });
        }
    }

    private static <T> T getValueFromBlockEntity(LevelAccessor world, BlockPos pos, Function<CompoundTag, T> getFunction, T defaultValue) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity != null) {
            LazyOptional capability = blockEntity.getCapability(CustomDataCapability.CUSTOM_DATA_CAPABILITY);
            return capability.map(dataHolder -> {
                CompoundTag customData = dataHolder.getCustomData();
                return getFunction.apply(customData);
            }).orElse(defaultValue);
        }
        return defaultValue;
    }
}

