/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.forge.network;

import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import net.rasanovum.viaromana.forge.ViaRomanaMod;
import net.rasanovum.viaromana.network.NetworkHandler;
import net.rasanovum.viaromana.network.ViaRomanaModVariables;

public class ViaRomanaModPacketHandler {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("via_romana", "main"), () -> "1", "1"::equals, "1"::equals);
    private static int packetId = 0;

    public static int getNextId() {
        return packetId++;
    }

    private static <MSG> void registerMessage(Class<MSG> messageType, BiConsumer<MSG, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, MSG> decoder, BiConsumer<MSG, Supplier<NetworkEvent.Context>> messageConsumer) {
        INSTANCE.registerMessage(ViaRomanaModPacketHandler.getNextId(), messageType, encoder, decoder, messageConsumer);
    }

    public static void initialize() {
        ViaRomanaMod.LOGGER.info("Initializing network handler");
        ViaRomanaModPacketHandler.registerMessage(ViaRomanaModVariables.PlayerVariablesSyncMessage.class, ViaRomanaModVariables.PlayerVariablesSyncMessage::write, ViaRomanaModVariables.PlayerVariablesSyncMessage::new, (message, contextSupplier) -> {
            NetworkEvent.Context context = (NetworkEvent.Context)contextSupplier.get();
            context.enqueueWork(() -> {
                if (context.getDirection().getReceptionSide().isServer()) {
                    ServerPlayer player = context.getSender();
                    if (player != null) {
                        ViaRomanaModVariables.PlayerVariablesSyncMessage.handleServer(message, player);
                    }
                } else {
                    ViaRomanaModVariables.PlayerVariablesSyncMessage.handleClient(message);
                }
            });
            context.setPacketHandled(true);
        });
        ViaRomanaModPacketHandler.registerMessage(ViaRomanaModVariables.SavedDataSyncMessage.class, ViaRomanaModVariables.SavedDataSyncMessage::write, ViaRomanaModVariables.SavedDataSyncMessage::new, (message, contextSupplier) -> {
            NetworkEvent.Context context = (NetworkEvent.Context)contextSupplier.get();
            context.enqueueWork(() -> {
                if (context.getDirection().getReceptionSide().isClient()) {
                    ViaRomanaModVariables.SavedDataSyncMessage.handleClient(message);
                }
            });
            context.setPacketHandled(true);
        });
        ViaRomanaModVariables.networkHandler = new ForgeNetworkHandler();
    }

    static class ForgeNetworkHandler
    implements NetworkHandler {
        ForgeNetworkHandler() {
        }

        @Override
        public void sendToPlayer(ServerPlayer player, Object message) {
            if (player == null) {
                return;
            }
            if (message instanceof ViaRomanaModVariables.PlayerVariablesSyncMessage) {
                ViaRomanaModVariables.PlayerVariablesSyncMessage syncMessage = (ViaRomanaModVariables.PlayerVariablesSyncMessage)message;
                INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)syncMessage);
            } else if (message instanceof ViaRomanaModVariables.SavedDataSyncMessage) {
                ViaRomanaModVariables.SavedDataSyncMessage syncMessage = (ViaRomanaModVariables.SavedDataSyncMessage)message;
                INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)syncMessage);
            } else {
                ViaRomanaMod.LOGGER.error("Attempted to send unknown message type via ForgeNetworkHandler: {}", (Object)message.getClass().getName());
            }
        }
    }
}

