/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.forge.configuration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.common.ForgeConfigSpec;
import net.rasanovum.viaromana.forge.ViaRomanaMod;
import net.rasanovum.viaromana.forge.configuration.ConfigConfiguration;
import net.rasanovum.viaromana.forge.init.ViaRomanaModConfigs;
import net.rasanovum.viaromana.variables.VariableAccess;

public class ConfigVariables {
    public static void load(LevelAccessor world) {
        String valid_tag_string = "";
        String valid_id_string = "";
        String valid_name_string = "";
        String valid_dimension_string = "";
        String valid_entity_string = "";
        String valid_sign_id_string = "";
        ForgeConfigSpec.DoubleValue infrastructureRadius = (ForgeConfigSpec.DoubleValue)ViaRomanaModConfigs.getConfigValue(ConfigConfiguration.class, "infrastructure_check_radius");
        VariableAccess.mapVariables.setInfrastructureCheckRadius(world, (Double)infrastructureRadius.get());
        ForgeConfigSpec.DoubleValue pathQualityThreshold = (ForgeConfigSpec.DoubleValue)ViaRomanaModConfigs.getConfigValue(ConfigConfiguration.class, "path_quality_threshold");
        VariableAccess.mapVariables.setInfrastructureCheckQuality(world, (Double)pathQualityThreshold.get());
        ForgeConfigSpec.DoubleValue nodeDistMin = (ForgeConfigSpec.DoubleValue)ViaRomanaModConfigs.getConfigValue(ConfigConfiguration.class, "node_distance_minimum");
        VariableAccess.mapVariables.setNodeDistanceMinimum(world, (Double)nodeDistMin.get());
        ForgeConfigSpec.DoubleValue nodeDistMax = (ForgeConfigSpec.DoubleValue)ViaRomanaModConfigs.getConfigValue(ConfigConfiguration.class, "node_distance_maximum");
        VariableAccess.mapVariables.setNodeDistanceMaximum(world, (Double)nodeDistMax.get());
        ForgeConfigSpec.DoubleValue pathDistMin = (ForgeConfigSpec.DoubleValue)ViaRomanaModConfigs.getConfigValue(ConfigConfiguration.class, "path_distance_minimum");
        VariableAccess.mapVariables.setPathDistanceMinimum(world, (Double)pathDistMin.get());
        ForgeConfigSpec.DoubleValue pathDistMax = (ForgeConfigSpec.DoubleValue)ViaRomanaModConfigs.getConfigValue(ConfigConfiguration.class, "path_distance_maximum");
        VariableAccess.mapVariables.setPathDistanceMaximum(world, (Double)pathDistMax.get());
        ForgeConfigSpec.DoubleValue travelFatigue = (ForgeConfigSpec.DoubleValue)ViaRomanaModConfigs.getConfigValue(ConfigConfiguration.class, "travel_fatigue_cooldown");
        VariableAccess.mapVariables.setTravelFatigueCooldown(world, (Double)travelFatigue.get());
        ForgeConfigSpec.ConfigValue validTags = (ForgeConfigSpec.ConfigValue)ViaRomanaModConfigs.getConfigValue(ConfigConfiguration.class, "valid_block_tags");
        valid_tag_string = (String)validTags.get();
        ForgeConfigSpec.ConfigValue validBlockIds = (ForgeConfigSpec.ConfigValue)ViaRomanaModConfigs.getConfigValue(ConfigConfiguration.class, "valid_block_ids");
        valid_id_string = (String)validBlockIds.get();
        ForgeConfigSpec.ConfigValue validBlockStrings = (ForgeConfigSpec.ConfigValue)ViaRomanaModConfigs.getConfigValue(ConfigConfiguration.class, "valid_block_strings");
        valid_name_string = (String)validBlockStrings.get();
        ForgeConfigSpec.ConfigValue validDimensions = (ForgeConfigSpec.ConfigValue)ViaRomanaModConfigs.getConfigValue(ConfigConfiguration.class, "valid_dimensions");
        valid_dimension_string = (String)validDimensions.get();
        ForgeConfigSpec.ConfigValue validEntities = (ForgeConfigSpec.ConfigValue)ViaRomanaModConfigs.getConfigValue(ConfigConfiguration.class, "valid_entities");
        valid_entity_string = (String)validEntities.get();
        ForgeConfigSpec.ConfigValue validSignStrings = (ForgeConfigSpec.ConfigValue)ViaRomanaModConfigs.getConfigValue(ConfigConfiguration.class, "valid_sign_strings");
        valid_sign_id_string = (String)validSignStrings.get();
        VariableAccess.mapVariables.setValidTagList(ConfigVariables.createListFromCommaSeparated(valid_tag_string));
        VariableAccess.mapVariables.setValidBlockList(world, ConfigVariables.createListFromCommaSeparated(valid_id_string));
        VariableAccess.mapVariables.setValidStringList(world, ConfigVariables.createListFromCommaSeparated(valid_name_string));
        VariableAccess.mapVariables.setValidDimensionList(world, ConfigVariables.createListFromCommaSeparated(valid_dimension_string));
        VariableAccess.mapVariables.setValidEntityList(world, ConfigVariables.createListFromCommaSeparated(valid_entity_string));
        VariableAccess.mapVariables.setValidSignList(world, ConfigVariables.createListFromCommaSeparated(valid_sign_id_string));
        VariableAccess.mapVariables.markAndSync(world);
        ViaRomanaMod.LOGGER.info("Config Loaded");
    }

    private static List<Object> createListFromCommaSeparated(String commaSeparated) {
        return new ArrayList<Object>(Arrays.asList(commaSeparated.replace(" ", "").split(",")));
    }
}

