/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.forge.capabilities;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.rasanovum.viaromana.forge.util.ICustomDataHolder;

public class CustomDataCapability {
    public static final Capability<ICustomDataHolder> CUSTOM_DATA_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<ICustomDataHolder>(){});
    public static final ResourceLocation CUSTOM_DATA_ID = new ResourceLocation("via_romana", "custom_data");

    public static void onAttachCapabilitiesToBlockEntity(AttachCapabilitiesEvent<BlockEntity> event) {
        Provider provider = new Provider();
        event.addCapability(CUSTOM_DATA_ID, (ICapabilityProvider)provider);
    }

    public static class Provider
    implements ICapabilityProvider,
    INBTSerializable<CompoundTag> {
        private final CustomDataHolder customData = new CustomDataHolder();
        private final LazyOptional<ICustomDataHolder> customDataOptional = LazyOptional.of(() -> this.customData);

        @Nonnull
        public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
            return CUSTOM_DATA_CAPABILITY.orEmpty(cap, this.customDataOptional);
        }

        public CompoundTag serializeNBT() {
            return this.customData.serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.customData.deserializeNBT(nbt);
        }
    }

    public static class CustomDataHolder
    implements ICustomDataHolder,
    INBTSerializable<CompoundTag> {
        private CompoundTag customData = new CompoundTag();

        @Override
        public CompoundTag getCustomData() {
            return this.customData;
        }

        @Override
        public void setCustomData(CompoundTag data) {
            this.customData = data;
        }

        public CompoundTag serializeNBT() {
            return this.customData.m_6426_();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.customData = nbt;
        }
    }
}

