/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.forge;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.rasanovum.viaromana.forge.capabilities.CustomDataCapability;
import net.rasanovum.viaromana.forge.init.ViaRomanaModConfigs;
import net.rasanovum.viaromana.forge.init.ViaRomanaModMobEffects;
import net.rasanovum.viaromana.forge.network.ViaRomanaModPacketHandler;
import net.rasanovum.viaromana.network.ViaRomanaModVariables;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="via_romana")
public class ViaRomanaMod {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "via_romana";

    public ViaRomanaMod() {
        LOGGER.info("Initializing ViaRomanaMod");
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ViaRomanaModMobEffects.register(modEventBus);
        modEventBus.addListener(this::setup);
        ViaRomanaModConfigs.register();
        MinecraftForge.EVENT_BUS.addGenericListener(BlockEntity.class, CustomDataCapability::onAttachCapabilitiesToBlockEntity);
        this.registerServerLifecycleEvents();
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> ViaRomanaModPacketHandler.initialize());
    }

    private void registerServerLifecycleEvents() {
        MinecraftForge.EVENT_BUS.addListener(event -> {
            Player patt0$temp = event.getEntity();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                ViaRomanaModVariables.playerLoggedIn(player);
            }
        });
        MinecraftForge.EVENT_BUS.addListener(event -> {
            Player patt0$temp = event.getEntity();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                ViaRomanaModVariables.playerLoggedOut(player);
            }
        });
        MinecraftForge.EVENT_BUS.addListener(event -> {
            Player patt0$temp = event.getEntity();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer newPlayer = (ServerPlayer)patt0$temp;
                boolean keepInventory = event.isEndConquered();
                ViaRomanaModVariables.playerRespawned(null, newPlayer, keepInventory);
            }
        });
    }
}

