/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.core;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.rasanovum.viaromana.PlatformUtils;
import net.rasanovum.viaromana.core.ResetVariables;
import net.rasanovum.viaromana.core.SignCheck;
import net.rasanovum.viaromana.util.PathUtils;
import net.rasanovum.viaromana.variables.VariableAccess;

public class TeleportHandler {
    public static void start(LevelAccessor world, double x, double y, double z, Entity entity) {
        if (entity == null) {
            return;
        }
        String pathData = PlatformUtils.getString(world, BlockPos.m_274561_((double)x, (double)y, (double)z), SignCheck.getTarget(world, x, y, z, entity));
        VariableAccess.playerVariables.setPathData(entity, pathData);
        if (SignCheck.isSignFound(world, x, y, z, entity)) {
            VariableAccess.playerVariables.setFadeAmount(entity, 0.0);
            VariableAccess.playerVariables.setLastNodeX(entity, x);
            VariableAccess.playerVariables.setLastNodeY(entity, y);
            VariableAccess.playerVariables.setLastNodeZ(entity, z);
            VariableAccess.playerVariables.setLastSignPosition(entity, SignCheck.getTarget(world, x, y, z, entity));
            VariableAccess.playerVariables.setFadeIncrease(entity, true);
        }
        VariableAccess.playerVariables.syncAndSave(entity);
    }

    public static void cycle(LevelAccessor world, double x, double y, double z, Entity entity) {
        if (entity == null || !entity.m_6084_()) {
            return;
        }
        TeleportHandler.handleFadeEffect(world, x, y, z, entity);
        if (VariableAccess.playerVariables.getFadeAmount(entity) == 10.0) {
            TeleportHandler.performTeleport(world, entity);
        }
        if (VariableAccess.playerVariables.getFadeAmount(entity) >= 15.0) {
            VariableAccess.playerVariables.setFadeIncrease(entity, false);
            VariableAccess.playerVariables.syncAndSave(entity);
        }
    }

    public static void effect(LevelAccessor world, double x, double y, double z, Entity entity) {
        if (entity == null) {
            return;
        }
        double fadeAmount = VariableAccess.playerVariables.getFadeAmount(entity);
        if (fadeAmount > 0.0) {
            double particleRadius = 4.0;
            if (world instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)world;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123809_, x + Mth.m_216263_((RandomSource)RandomSource.m_216327_(), (double)-0.1, (double)0.1) * particleRadius, y + fadeAmount * 0.15, z + Mth.m_216263_((RandomSource)RandomSource.m_216327_(), (double)-0.1, (double)0.1) * particleRadius, 32, Mth.m_216263_((RandomSource)RandomSource.m_216327_(), (double)-0.1, (double)0.1) * particleRadius, fadeAmount * 0.02, Mth.m_216263_((RandomSource)RandomSource.m_216327_(), (double)-0.1, (double)0.1) * particleRadius, 0.5);
            }
        }
    }

    private static void playFootstepSound(LevelAccessor world, double x, double y, double z) {
        if (!(world instanceof Level)) {
            return;
        }
        Level level = (Level)world;
        BlockPos pos = BlockPos.m_274561_((double)x, (double)Math.ceil(y - 1.0), (double)z);
        BlockState blockState = world.m_8055_(pos);
        ResourceLocation soundId = BuiltInRegistries.f_256894_.m_7981_((Object)blockState.m_60827_().m_56776_());
        if (soundId == null) {
            soundId = new ResourceLocation("block.grass.step");
        }
        if (!level.m_5776_()) {
            level.m_5594_(null, pos, (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(soundId), SoundSource.BLOCKS, 0.5f, 1.0f);
        } else {
            level.m_7785_(x, y, z, (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(soundId), SoundSource.BLOCKS, 0.5f, 1.0f, false);
        }
    }

    private static void handleFadeEffect(LevelAccessor world, double x, double y, double z, Entity entity) {
        double fadeAmount = VariableAccess.playerVariables.getFadeAmount(entity);
        if (fadeAmount >= 0.0 && fadeAmount <= 15.0) {
            boolean isIncreasing;
            if (fadeAmount % 7.0 == 0.0) {
                TeleportHandler.playFootstepSound(world, x, y, z);
            }
            double newFadeAmount = (isIncreasing = VariableAccess.playerVariables.isFadeIncrease(entity)) ? fadeAmount + 1.0 : fadeAmount - 1.0;
            VariableAccess.playerVariables.setFadeAmount(entity, newFadeAmount);
            VariableAccess.playerVariables.syncAndSave(entity);
            if (fadeAmount == 1.0) {
                PlatformUtils.applyEffect(entity, "travellers_fatigue", world);
            }
        }
    }

    private static void performTeleport(LevelAccessor world, Entity entity) {
        String pathData = VariableAccess.playerVariables.getPathData(entity);
        if (pathData.isEmpty()) {
            return;
        }
        try {
            Entity mountEntity;
            ArrayList<Object> teleportData = PathUtils.decodePathData(pathData);
            double targetX = (Double)teleportData.get(0);
            double targetY = (Double)teleportData.get(1);
            double targetZ = (Double)teleportData.get(2);
            if (entity.m_20159_()) {
                mountEntity = entity.m_20202_();
                entity.m_8127_();
                if (mountEntity != null && VariableAccess.mapVariables.getValidEntityList(world).contains(BuiltInRegistries.f_256780_.m_7981_((Object)mountEntity.m_6095_()).toString())) {
                    TeleportHandler.teleportEntity(mountEntity, targetX, targetY, targetZ);
                }
            } else {
                mountEntity = null;
            }
            TeleportHandler.teleportEntity(entity, targetX, targetY, targetZ);
            if (mountEntity != null) {
                if (world instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)world;
                    serverLevel.m_7654_().m_6937_((Runnable)new TickTask(1, () -> entity.m_7998_(mountEntity, true)));
                } else {
                    entity.m_7998_(mountEntity, true);
                }
            }
            ResetVariables.execute(world, entity);
        }
        catch (ClassCastException | IndexOutOfBoundsException e) {
            Player player;
            if (entity instanceof Player && !(player = (Player)entity).m_9236_().m_5776_()) {
                player.m_5661_((Component)Component.m_237113_((String)"Error: Invalid path data format during teleport."), true);
            }
            ResetVariables.execute(world, entity);
        }
    }

    private static void teleportEntity(Entity entity, double x, double y, double z) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            serverPlayer.m_19890_(x, Math.ceil(y), z, entity.m_146908_(), entity.m_146909_());
            serverPlayer.f_19789_ = 0.0f;
            serverPlayer.f_8906_.m_9774_(x, Math.ceil(y), z, entity.m_146908_(), entity.m_146909_());
            serverPlayer.m_20334_(0.0, 0.0, 0.0);
            serverPlayer.m_6853_(true);
        } else {
            entity.m_6021_(x, Math.ceil(y), z);
            entity.m_20334_(0.0, 0.0, 0.0);
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                living.f_19789_ = 0.0f;
                living.m_6853_(true);
            }
        }
    }
}

